/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.localization;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import tsp.nexuslib.localization.Message;

@ParametersAreNonnullByDefault
public class TranslatableLocalization {
    private final JavaPlugin plugin;
    private final String messagesPath;
    private final File container;
    private final String defaultLanguage;
    private final Map<UUID, String> languages;
    private final Map<String, FileConfiguration> data;
    private String consoleLanguage;
    private boolean colorize;
    private final Pattern ARGS_PATTERN = Pattern.compile("(\\{\\$arg(\\d+)\\})", 2);
    private final Pattern DELIMITER = Pattern.compile("=");
    private ConsoleMessageFunction logFunction = message -> Bukkit.getConsoleSender().sendMessage(message);

    public TranslatableLocalization(JavaPlugin plugin, String messagesPath, @Nullable File container, @Nullable String defaultLanguage) {
        this.notNull(plugin, "Plugin can not be null!");
        this.notNull(messagesPath, "Messages path can not be null!");
        this.plugin = plugin;
        this.messagesPath = messagesPath;
        this.container = container;
        this.defaultLanguage = defaultLanguage;
        this.languages = new HashMap<UUID, String>();
        this.data = new HashMap<String, FileConfiguration>();
        this.consoleLanguage = defaultLanguage;
        this.colorize = true;
    }

    public TranslatableLocalization(JavaPlugin plugin, String messagesPath) {
        this(plugin, messagesPath, new File(plugin.getDataFolder() + "/messages"), "en");
    }

    private void sendTranslatedMessage(UUID uuid, String message) {
        this.notNull(uuid, "UUID can not be null!");
        this.notNull(message, "Message can not be null!");
        if (message.isEmpty()) {
            return;
        }
        Entity receiver = Bukkit.getEntity((UUID)uuid);
        if (receiver == null) {
            throw new IllegalArgumentException("Invalid receiver with uuid: " + uuid.toString());
        }
        receiver.sendMessage(message);
    }

    private void sendTranslatedMessage(CommandSender receiver, String message) {
        this.notNull(receiver, "UUID can not be null!");
        this.notNull(message, "Message can not be null!");
        if (message.isEmpty()) {
            return;
        }
        receiver.sendMessage(message);
    }

    public void sendMessage(UUID receiver, String key, @Nullable UnaryOperator<String> function, String ... args) {
        this.notNull(receiver, "Receiver can not be null!");
        this.notNull(key, "Key can not be null!");
        this.getMessage(receiver, key).ifPresent(message -> {
            if (args != null) {
                for (String arg : args) {
                    if (arg == null) continue;
                    Matcher matcher = this.ARGS_PATTERN.matcher((CharSequence)message);
                    while (matcher.find()) {
                        message = matcher.replaceAll(args[Integer.parseInt(matcher.group(2))]);
                    }
                }
            }
            message = function != null ? (String)function.apply((String)message) : message;
            this.sendTranslatedMessage(receiver, this.colorize ? ChatColor.translateAlternateColorCodes((char)'&', (String)message) : message);
        });
    }

    public void sendMessage(UUID receiver, String key, @Nullable UnaryOperator<String> function) {
        this.sendMessage(receiver, key, function, (String[])null);
    }

    public void sendMessage(UUID receiver, String key, String ... args) {
        this.sendMessage(receiver, key, (UnaryOperator<String>)null, args);
    }

    public void sendMessage(UUID receiver, String key) {
        this.sendMessage(receiver, key, (UnaryOperator<String>)null, (String[])null);
    }

    public void sendMessages(String key, UUID ... receivers) {
        for (UUID receiver : receivers) {
            this.sendMessage(receiver, key);
        }
    }

    @Nonnull
    public Optional<String> getMessage(UUID uuid, String key) {
        this.notNull(uuid, "UUID can not be null!");
        this.notNull(key, "Key can not be null!");
        FileConfiguration messages = this.data.get(this.languages.getOrDefault(uuid, this.defaultLanguage));
        if (messages == null) {
            return Optional.empty();
        }
        String message = messages.getString(key);
        if (message == null) {
            messages = this.data.get(this.defaultLanguage);
            message = messages.getString(key);
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null && message != null) {
            message = PlaceholderAPI.setPlaceholders((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)uuid), (String)message);
        }
        return Optional.ofNullable(message);
    }

    @Nonnull
    public Optional<String> getMessage(Player player, String key) {
        return this.getMessage(player.getUniqueId(), key);
    }

    public void sendTranslatedConsoleMessage(String message) {
        this.notNull(message, "Message can not be null!");
        if (message.isEmpty()) {
            return;
        }
        this.logFunction.logMessage(message);
    }

    public void sendConsoleMessage(String key, @Nullable UnaryOperator<String> function, String ... args) {
        this.notNull(key, "Key can not be null!");
        this.getConsoleMessage(key).ifPresent(message -> {
            if (args != null) {
                for (String arg : args) {
                    if (arg == null) continue;
                    Matcher matcher = this.ARGS_PATTERN.matcher((CharSequence)message);
                    while (matcher.find()) {
                        message = matcher.replaceAll(args[Integer.parseInt(matcher.group(2))]);
                    }
                }
            }
            message = function != null ? (String)function.apply((String)message) : message;
            this.sendTranslatedConsoleMessage(this.colorize ? ChatColor.translateAlternateColorCodes((char)'&', (String)message) : message);
        });
    }

    public void sendConsoleMessage(String key, @Nullable UnaryOperator<String> function) {
        this.sendConsoleMessage(key, function, (String[])null);
    }

    public void sendConsoleMessage(String key, String ... args) {
        this.sendConsoleMessage(key, (UnaryOperator<String>)null, args);
    }

    public void sendConsoleMessage(String key) {
        this.sendConsoleMessage(key, (UnaryOperator<String>)null, (String[])null);
    }

    public Optional<String> getConsoleMessage(String key) {
        this.notNull(key, "Key can not be null!");
        FileConfiguration messages = this.data.get(this.consoleLanguage != null ? this.consoleLanguage : this.defaultLanguage);
        if (messages == null) {
            return Optional.empty();
        }
        String message = messages.getString(key);
        if (message == null) {
            messages = this.data.get(this.defaultLanguage);
            message = messages.getString(key);
        }
        return Optional.ofNullable(message);
    }

    public void setLogFunction(ConsoleMessageFunction logFunction) {
        this.logFunction = logFunction;
    }

    public void sendMessage(CommandSender receiver, String key, @Nullable UnaryOperator<String> function, String ... args) {
        if (receiver instanceof ConsoleCommandSender || receiver instanceof RemoteConsoleCommandSender) {
            this.sendConsoleMessage(key, function, args);
        } else if (receiver instanceof Player) {
            Player player = (Player)receiver;
            this.notNull(receiver, "Receiver can not be null!");
            this.notNull(key, "Key can not be null!");
            this.getMessage(player.getUniqueId(), key).ifPresent(message -> {
                if (args != null) {
                    for (String arg : args) {
                        if (arg == null) continue;
                        Matcher matcher = this.ARGS_PATTERN.matcher((CharSequence)message);
                        while (matcher.find()) {
                            message = matcher.replaceAll(args[Integer.parseInt(matcher.group(2))]);
                        }
                    }
                }
                message = function != null ? (String)function.apply((String)message) : message;
                this.sendTranslatedMessage((CommandSender)player, this.colorize ? ChatColor.translateAlternateColorCodes((char)'&', (String)message) : message);
            });
        }
    }

    public void sendMessage(CommandSender receiver, String key, @Nullable UnaryOperator<String> function) {
        this.sendMessage(receiver, key, function, (String[])null);
    }

    public void sendMessage(CommandSender receiver, String key) {
        this.sendMessage(receiver, key, null);
    }

    public void sendMessage(String key, CommandSender ... receivers) {
        for (CommandSender receiver : receivers) {
            this.sendMessage(receiver, key);
        }
    }

    public void sendMessage(Message message) {
        message.getReceivers().forEach(uuid -> this.sendMessage((UUID)uuid, message.getText(), message.getFunction(), message.getArgs()));
        if (message.shouldSendToConsole()) {
            this.sendConsoleMessage(message.getText(), message.getFunction(), message.getArgs());
        }
    }

    public int load() {
        File[] files = this.container.listFiles();
        if (files == null) {
            throw new NullPointerException("No files in container!");
        }
        int count = 0;
        for (File file : files) {
            String name = file.getName();
            if (!name.endsWith(".yml") && !name.endsWith(".yaml")) continue;
            this.data.put(name.substring(0, name.lastIndexOf(".")), (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
            ++count;
        }
        return count;
    }

    public void createDefaults() throws URISyntaxException, IOException {
        URL url = this.plugin.getClass().getClassLoader().getResource(this.messagesPath);
        if (url == null) {
            throw new NullPointerException("No resource with path: " + this.messagesPath);
        }
        if (!this.container.exists()) {
            this.container.mkdir();
        }
        String[] array = url.toURI().toString().split("!");
        FileSystem fs = FileSystems.newFileSystem(URI.create(array[0]), new HashMap());
        Files.walk(Paths.get(url.toURI()), new FileVisitOption[0]).forEach(path -> {
            try {
                File out = new File(this.container.getAbsolutePath() + "/" + path.getFileName());
                if ((out.getName().endsWith(".yml") || out.getName().endsWith(".yaml")) && !out.exists()) {
                    Files.copy(path, out.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        fs.close();
    }

    public void loadLanguages(File file, boolean skipInvalids) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] args = this.DELIMITER.split(line);
                if (args.length != 1 && !skipInvalids) {
                    throw new IllegalArgumentException("Invalid language entry: " + line);
                }
                this.languages.put(UUID.fromString(args[0]), args[1]);
            }
        }
    }

    public void loadLanguages(File file) throws IOException {
        this.loadLanguages(file, true);
    }

    public void saveLanguages(File file) throws FileNotFoundException {
        try (PrintWriter writer = new PrintWriter(file);){
            for (Map.Entry<UUID, String> entry : this.languages.entrySet()) {
                writer.println(entry.getKey().toString() + "=" + entry.getValue());
            }
        }
    }

    @Nonnull
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Nonnull
    public File getContainer() {
        return this.container;
    }

    @Nonnull
    public String getMessagesPath() {
        return this.messagesPath;
    }

    public Map<String, FileConfiguration> getData() {
        return this.data;
    }

    @Nonnull
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Nonnull
    public Map<UUID, String> getLanguageMap() {
        return Collections.unmodifiableMap(this.languages);
    }

    @Nonnull
    public Optional<String> getLanguage(UUID uuid) {
        return Optional.ofNullable(this.languages.get(uuid));
    }

    public void setLanguage(UUID uuid, String lang) {
        this.notNull(uuid, "UUID can not be null!");
        this.notNull(lang, "Lang can not be null!");
        this.languages.put(uuid, lang);
    }

    public void removeLanguage(UUID uuid) {
        this.notNull(uuid, "UUID can not be null!");
        this.languages.remove(uuid);
    }

    public boolean isColorize() {
        return this.colorize;
    }

    public void setColorize(boolean colorize) {
        this.colorize = colorize;
    }

    @Nonnull
    public String getConsoleLanguage() {
        return this.consoleLanguage;
    }

    public void setConsoleLanguage(String consoleLanguage) {
        this.notNull(consoleLanguage, "Language can not be null!");
        this.consoleLanguage = consoleLanguage;
    }

    private <T> void notNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
    }

    public static interface ConsoleMessageFunction {
        public void logMessage(String var1);
    }
}

