/*
 * Decompiled with CFR 0.152.
 */
package tsp.helperlite.scheduler.threadlock;

import java.util.concurrent.CountDownLatch;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import tsp.helperlite.HelperLite;
import tsp.helperlite.scheduler.ThreadContext;
import tsp.helperlite.scheduler.threadlock.ServerThreadLock;

final class ServerThreadLockImpl
implements ServerThreadLock {
    private final CountDownLatch obtainedSignal = new CountDownLatch(1);
    private final CountDownLatch doneSignal = new CountDownLatch(1);

    ServerThreadLockImpl() {
        if (ThreadContext.forCurrentThread() == ThreadContext.SYNC) {
            this.obtainedSignal.countDown();
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)HelperLite.getPlugin(), this::signal);
        this.await();
    }

    @Override
    public void close() {
        this.doneSignal.countDown();
    }

    private void await() {
        try {
            this.obtainedSignal.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void signal() {
        this.obtainedSignal.countDown();
        try {
            this.doneSignal.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

