/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.implementation.head;

import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.inventory.ItemStack;
import tsp.headdb.core.util.Utils;
import tsp.headdb.implementation.category.Category;
import tsp.nexuslib.util.Validate;

public class Head {
    private final int id;
    private final UUID uniqueId;
    private final String name;
    private final String texture;
    private final String tags;
    private final String updated;
    private final Category category;
    private ItemStack item;

    @ParametersAreNonnullByDefault
    public Head(int id, UUID uniqueId, String name, String texture, String tags, String updated, Category category) {
        Validate.notNull(uniqueId, "Unique id can not be null!");
        Validate.notNull(name, "Name can not be null!");
        Validate.notNull(texture, "Texture can not be null!");
        Validate.notNull(tags, "Tags can not be null!");
        Validate.notNull(updated, "Updated can not be null!");
        Validate.notNull(category, "Category can not be null!");
        this.id = id;
        this.uniqueId = uniqueId;
        this.name = name;
        this.texture = texture;
        this.tags = tags;
        this.updated = updated;
        this.category = category;
    }

    public ItemStack getItem(UUID receiver) {
        if (this.item == null) {
            this.item = Utils.asItem(receiver, this);
        }
        return this.item.clone();
    }

    public int getId() {
        return this.id;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public String getName() {
        return this.name;
    }

    public String getTexture() {
        return this.texture;
    }

    public String getTags() {
        return this.tags;
    }

    public String getUpdated() {
        return this.updated;
    }

    public Category getCategory() {
        return this.category;
    }
}

