/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.core.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import tsp.headdb.core.command.SubCommand;

public class CommandManager {
    private final Map<String, SubCommand> commands = new HashMap<String, SubCommand>();

    public void register(SubCommand command) {
        this.commands.put(command.getName(), command);
    }

    public Optional<SubCommand> getCommand(String name) {
        SubCommand command = this.commands.get(name);
        if (command != null) {
            return Optional.of(command);
        }
        return this.getCommandByAlias(name);
    }

    public Optional<SubCommand> getCommandByAlias(String alias) {
        for (SubCommand entry : this.commands.values()) {
            if (!entry.getAliases().isPresent() || !Arrays.stream(entry.getAliases().get()).anyMatch(name -> name.equalsIgnoreCase(alias))) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    public Map<String, SubCommand> getCommandsMap() {
        return this.commands;
    }
}

