/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.inventory;

import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import tsp.nexuslib.inventory.Button;
import tsp.nexuslib.inventory.Page;
import tsp.nexuslib.util.Validate;

public class Pane
implements InventoryHolder {
    private final Inventory inventory;
    private final Page page;

    public Pane(int rows, @Nonnull String title) {
        Validate.notNull(title, "title can not be null!");
        if (rows > 6) {
            throw new IllegalArgumentException("Rows must be <= 6, got " + rows);
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (String)title);
        this.page = new Page(rows);
    }

    public void addButton(@Nonnull Button button) {
        Validate.notNull(button, "Button must not be null!");
        if (this.page.hasSpace()) {
            this.page.addButton(button);
            this.reRender();
        }
    }

    public void setButton(int i, @Nonnull Button button) {
        Validate.notNull(button, "Button must not be null!");
        this.page.setButton(i, button);
        this.reRender();
    }

    public void removeButton(@Nonnull Button button) {
        Validate.notNull(button, "Button must not be null!");
        this.page.removeButton(button);
        this.reRender();
    }

    public void onClick(InventoryClickEvent event) {
        Validate.notNull(event, "InventoryClickEvent must not be null!");
        event.setCancelled(true);
        this.page.handleClick(event);
    }

    public void reRender() {
        this.inventory.clear();
        this.page.render(this.inventory);
    }

    @Nonnull
    public Inventory getInventory() {
        return this.inventory;
    }

    public Page getPage() {
        return this.page;
    }

    public void open(Player player) {
        Validate.notNull(player, "Player must not be null!");
        this.reRender();
        player.openInventory(this.getInventory());
    }
}

