/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.config;

import com.google.common.annotations.Beta;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

@Beta
public class Config {
    private FileConfiguration data;

    public Config(FileConfiguration data) {
        this.data = data;
    }

    public Config(File file) {
        this.data = YamlConfiguration.loadConfiguration((File)file);
    }

    public void reload(File file) {
        this.data = YamlConfiguration.loadConfiguration((File)file);
    }

    public void reload(FileConfiguration data) {
        this.data = data;
    }

    @Nullable
    public Optional<Object> getOptional(@Nonnull String path) {
        return Optional.ofNullable(this.data.get(path));
    }

    @Nonnull
    public <T> Optional<T> getOptionalObject(@Nonnull String path, @Nonnull Class<T> clazz) {
        return Optional.ofNullable(this.data.getObject(path, clazz));
    }

    public Optional<Boolean> getOptionalBoolean(@Nonnull String path) {
        return this.data.contains(path) ? Optional.of(this.data.getBoolean(path)) : Optional.empty();
    }

    public Optional<Color> getOptionalColor(@Nonnull String path) {
        return Optional.ofNullable(this.data.getColor(path));
    }

    public Optional<Double> getOptionalDouble(@Nonnull String path) {
        Object object = this.data.get(path);
        if (object instanceof Double) {
            Double n = (Double)object;
            return Optional.of(n);
        }
        return Optional.empty();
    }

    public float getFloat(@Nonnull String path) {
        return this.getFloat(path, 0.0f);
    }

    public float getFloat(@Nonnull String path, float def) {
        Object object = this.data.get(path);
        if (object instanceof Float) {
            Float n = (Float)object;
            return n.floatValue();
        }
        return def;
    }

    public Optional<Float> getOptionalFloat(@Nonnull String path) {
        Object object = this.data.get(path);
        if (object instanceof Float) {
            Float n = (Float)object;
            return Optional.of(n);
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<Integer> getOptionalInt(@Nonnull String path) {
        Object object = this.data.get(path);
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return Optional.of(n);
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<Long> getOptionalLong(@Nonnull String path) {
        Object object = this.data.get(path);
        if (object instanceof Long) {
            Long n = (Long)object;
            return Optional.of(n);
        }
        return Optional.empty();
    }

    @Nullable
    public Number getNumber(@Nonnull String path) {
        Object object = this.data.get(path);
        if (object instanceof Number) {
            Number number = (Number)object;
            return number;
        }
        return null;
    }

    @Nonnull
    public Optional<Number> getOptionalNumber(@Nonnull String path) {
        return Optional.ofNullable(this.getNumber(path));
    }

    @Nonnull
    public Optional<String> getOptionalString(@Nonnull String path) {
        return Optional.ofNullable(this.data.getString(path));
    }

    @Nonnull
    public <T> Optional<List<T>> getOptionalList(@Nonnull String path, Class<T> clazz) {
        List list = this.data.getList(path);
        if (list != null && !list.isEmpty() && list.get(0).getClass().isInstance(clazz)) {
            return Optional.of(list);
        }
        return Optional.empty();
    }

    @Nonnull
    public <T extends ConfigurationSerializable> Optional<ConfigurationSerializable> getOptionalSerializable(@Nonnull String path, @Nonnull Class<T> clazz) {
        return Optional.ofNullable(this.data.getSerializable(path, clazz));
    }

    @Nonnull
    public Optional<Vector> getOptionalVector(@Nonnull String path) {
        return Optional.ofNullable(this.data.getVector(path));
    }

    @Nonnull
    public Optional<ItemStack> getOptionalItemStack(@Nonnull String path) {
        return Optional.ofNullable(this.data.getItemStack(path));
    }

    @Nonnull
    public Optional<Location> getOptionalLocation(@Nonnull String path) {
        return Optional.ofNullable(this.data.getLocation(path));
    }

    @Nonnull
    public Optional<OfflinePlayer> getOptionalOfflinePlayer(@Nonnull String path) {
        return Optional.ofNullable(this.data.getOfflinePlayer(path));
    }

    @Nonnull
    public Optional<Configuration> getOptionalDefaults() {
        return Optional.ofNullable(this.data.getDefaults());
    }

    @Nonnull
    public Optional<Configuration> getOptionalRoot() {
        return Optional.ofNullable(this.data.getRoot());
    }

    @Nonnull
    public Optional<ConfigurationSection> getOptionalConfigurationSection(@Nonnull String path) {
        return Optional.ofNullable(this.data.getConfigurationSection(path));
    }

    public void setLocation(String path, Location location) {
        this.data.set(path, (Object)location);
    }

    public void setItemStack(String path, ItemStack itemStack) {
        this.data.set(path, (Object)itemStack);
    }
}

