/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.implementation.head;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.java.JavaPlugin;
import tsp.headdb.implementation.category.Category;
import tsp.headdb.implementation.head.Head;
import tsp.headdb.implementation.head.HeadResult;
import tsp.headdb.implementation.requester.HeadProvider;
import tsp.headdb.implementation.requester.Requester;
import tsp.helperlite.scheduler.promise.Promise;

public class HeadDatabase {
    private final JavaPlugin plugin;
    private final Requester requester;
    private final ConcurrentHashMap<Category, List<Head>> heads;
    private long timestamp;

    public HeadDatabase(JavaPlugin plugin, HeadProvider provider) {
        this.plugin = plugin;
        this.requester = new Requester(plugin, provider);
        this.heads = new ConcurrentHashMap();
        for (Category cat : Category.VALUES) {
            this.heads.put(cat, new ArrayList());
        }
    }

    public Map<Category, List<Head>> getHeads() {
        return this.heads;
    }

    public Promise<HeadResult> getHeadsNoCache() {
        return Promise.supplyingAsync(() -> {
            long start = System.currentTimeMillis();
            HashMap<Category, List<Head>> result = new HashMap<Category, List<Head>>();
            for (Category category : Category.VALUES) {
                result.put(category, this.requester.fetchAndResolve(category));
            }
            return new HeadResult(System.currentTimeMillis() - start, result);
        });
    }

    public Promise<HeadResult> update() {
        return Promise.start().thenComposeAsync(compose -> this.getHeadsNoCache()).thenApplyAsync(result -> {
            this.heads.clear();
            this.heads.putAll(result.heads());
            this.timestamp = System.currentTimeMillis();
            return result;
        });
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public Requester getRequester() {
        return this.requester;
    }
}

