/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.core.command;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tsp.headdb.core.api.HeadAPI;
import tsp.headdb.core.command.SubCommand;
import tsp.headdb.core.util.Utils;
import tsp.headdb.implementation.head.Head;
import tsp.nexuslib.inventory.PagedPane;

public class CommandSearch
extends SubCommand {
    public CommandSearch() {
        super("search", new String[]{"s"});
    }

    @Override
    public void handle(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.getLocalization().sendConsoleMessage("noConsole");
            return;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            this.getLocalization().sendMessage((CommandSender)player, "invalidArguments");
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            builder.append(args[i]);
            if (i == args.length - 1) continue;
            builder.append(" ");
        }
        String query = builder.toString();
        ArrayList<Head> heads = new ArrayList<Head>();
        List<Head> headList = HeadAPI.getHeads();
        if (query.length() > 3) {
            if (query.startsWith("id:")) {
                try {
                    HeadAPI.getHeadById(Integer.parseInt(query.substring(3))).ifPresent(heads::add);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (query.startsWith("tg:")) {
                heads.addAll(headList.stream().filter(head -> Utils.matches(head.getTags(), query.substring(3))).toList());
            } else {
                heads.addAll(headList.stream().filter(head -> Utils.matches(head.getName(), query)).toList());
            }
        } else {
            heads.addAll(headList.stream().filter(head -> Utils.matches(head.getName(), query)).toList());
        }
        this.getLocalization().sendMessage(player.getUniqueId(), "searchCommand", msg -> msg.replace("%query%", query));
        PagedPane main = Utils.createPaged(player, Utils.translateTitle(this.getLocalization().getMessage(player.getUniqueId(), "menu.search.name").orElse("&cHeadDB - &eSearch Results"), heads.size(), "None", query));
        Utils.addHeads(player, null, main, heads);
        this.getLocalization().sendMessage(player.getUniqueId(), "searchCommandResults", msg -> msg.replace("%size%", String.valueOf(heads.size())).replace("%query%", query));
        main.open(player);
    }
}

