/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhancraft;

import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.guizhanss.guizhancraft.core.services.ConfigService;
import net.guizhanss.guizhancraft.core.services.IntegrationService;
import net.guizhanss.guizhancraft.core.services.LocalizationService;
import net.guizhanss.guizhancraft.implementation.commands.SfSpawnerCommand;
import net.guizhanss.guizhancraft.implementation.commands.UnloadChunkCommand;
import net.guizhanss.guizhancraft.libs.bstats.bukkit.Metrics;
import net.guizhanss.guizhancraft.libs.guizhanlib.libraries.BukkitLibraryManager;
import net.guizhanss.guizhancraft.libs.guizhanlib.slimefun.addon.AbstractAddon;
import net.guizhanss.guizhancraft.libs.guizhanlib.slimefun.addon.Scheduler;
import net.guizhanss.guizhancraft.libs.guizhanlib.updater.GuizhanBuildsUpdater;
import net.guizhanss.guizhancraft.libs.libby.Library;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0014J\b\u0010\u0007\u001a\u00020\u0005H\u0014J\b\u0010\b\u001a\u00020\u0005H\u0014J\b\u0010\t\u001a\u00020\u0005H\u0002J\b\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"Lnet/guizhanss/guizhancraft/GuizhanCraft;", "Lnet/guizhanss/guizhancraft/libs/guizhanlib/slimefun/addon/AbstractAddon;", "<init>", "()V", "load", "", "enable", "disable", "autoUpdate", "setupCommands", "setupMetrics", "Companion", "GuizhanCraft"})
public final class GuizhanCraft
extends AbstractAddon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String GITHUB_USER = "ybw0014";
    @NotNull
    private static final String GITHUB_REPO = "GuizhanCraft";
    @NotNull
    private static final String GITHUB_BRANCH = "master";
    @NotNull
    private static final String AUTO_UPDATE_KEY = "auto-update";
    @NotNull
    public static final String DEFAULT_LANG = "en-US";
    private static GuizhanCraft instance;
    private static ConfigService configService;
    private static LocalizationService localization;
    private static IntegrationService integrationService;

    public GuizhanCraft() {
        super(GITHUB_USER, GITHUB_REPO, GITHUB_BRANCH, AUTO_UPDATE_KEY);
    }

    @Override
    protected void load() {
        String string = System.getProperty("centralRepository");
        if (string == null) {
            string = "https://repo1.maven.org/maven2/";
        }
        String centralRepo = string;
        this.getLogger().info("Loading libraries, please wait...");
        this.getLogger().info("If you stuck here for a long time, try to specify a mirror repository:");
        this.getLogger().info("Add -DcentralRepository=<url> to the JVM arguments.");
        BukkitLibraryManager manager = new BukkitLibraryManager((Plugin)this);
        manager.addRepository(centralRepo);
        manager.loadLibrary(Library.builder().groupId("org.jetbrains.kotlin").artifactId("kotlin-stdlib").version("2.1.20").build());
        manager.loadLibrary(Library.builder().groupId("org.jetbrains.kotlin").artifactId("kotlin-reflect").version("2.1.20").build());
        this.getLogger().info("Loaded all required libraries.");
    }

    @Override
    protected void enable() {
        instance = this;
        configService = new ConfigService(this);
        Companion.debug("Debug mode is enabled.");
        Level level = Level.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
        Companion.log(level, "Loading language...");
        String lang = Companion.getConfigService().getLang();
        File file = this.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        localization = new LocalizationService(this, file);
        Companion.getLocalization().setIdPrefix("GZ_");
        Companion.getLocalization().addLanguage(lang);
        if (!Intrinsics.areEqual((Object)lang, (Object)DEFAULT_LANG)) {
            Companion.getLocalization().addLanguage(DEFAULT_LANG);
        }
        Object[] objectArray = new Object[]{lang};
        AbstractAddon.log(Level.INFO, "Loaded language {0}.", objectArray);
        integrationService = new IntegrationService(this);
        if (Companion.getConfigService().getEnableResearches()) {
        }
        this.setupCommands();
        this.setupMetrics();
    }

    @Override
    protected void disable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    @Override
    protected void autoUpdate() {
        String string = this.getPluginVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPluginVersion(...)");
        if (StringsKt.startsWith$default((String)string, (String)"Dev", (boolean)false, (int)2, null)) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), this.getGithubRepo()).start();
        } else {
            String string2 = this.getPluginVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPluginVersion(...)");
            if (StringsKt.startsWith$default((String)string2, (String)"Build", (boolean)false, (int)2, null)) {
                try {
                    Class<?> clazz = Class.forName("net.guizhanss.minecraft.guizhanlib.updater.GuizhanUpdater");
                    Object[] objectArray = new Class[]{Plugin.class, File.class, String.class, String.class, String.class};
                    Method updaterStart = clazz.getDeclaredMethod("start", (Class<?>[])objectArray);
                    objectArray = new Object[]{this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()};
                    updaterStart.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    GuizhanBuildsUpdater.start((Plugin)this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch());
                }
            }
        }
    }

    private final void setupCommands() {
        new SfSpawnerCommand(AbstractAddon.getPluginCommand("sfspawner")).register();
        new UnloadChunkCommand(AbstractAddon.getPluginCommand("unloadchunk")).register();
    }

    private final void setupMetrics() {
        new Metrics((Plugin)this, 14629);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0013@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0017@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lnet/guizhanss/guizhancraft/GuizhanCraft$Companion;", "", "<init>", "()V", "GITHUB_USER", "", "GITHUB_REPO", "GITHUB_BRANCH", "AUTO_UPDATE_KEY", "DEFAULT_LANG", "value", "Lnet/guizhanss/guizhancraft/GuizhanCraft;", "instance", "getInstance", "()Lnet/guizhanss/guizhancraft/GuizhanCraft;", "Lnet/guizhanss/guizhancraft/core/services/ConfigService;", "configService", "getConfigService", "()Lnet/guizhanss/guizhancraft/core/services/ConfigService;", "Lnet/guizhanss/guizhancraft/core/services/LocalizationService;", "localization", "getLocalization", "()Lnet/guizhanss/guizhancraft/core/services/LocalizationService;", "Lnet/guizhanss/guizhancraft/core/services/IntegrationService;", "integrationService", "getIntegrationService", "()Lnet/guizhanss/guizhancraft/core/services/IntegrationService;", "scheduler", "Lnet/guizhanss/guizhancraft/libs/guizhanlib/slimefun/addon/Scheduler;", "log", "", "level", "Ljava/util/logging/Level;", "message", "ex", "", "debug", "GuizhanCraft"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GuizhanCraft getInstance() {
            GuizhanCraft guizhanCraft = instance;
            if (guizhanCraft != null) {
                return guizhanCraft;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        @NotNull
        public final ConfigService getConfigService() {
            ConfigService configService = configService;
            if (configService != null) {
                return configService;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"configService");
            return null;
        }

        @NotNull
        public final LocalizationService getLocalization() {
            LocalizationService localizationService = localization;
            if (localizationService != null) {
                return localizationService;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"localization");
            return null;
        }

        @NotNull
        public final IntegrationService getIntegrationService() {
            IntegrationService integrationService = integrationService;
            if (integrationService != null) {
                return integrationService;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"integrationService");
            return null;
        }

        @NotNull
        public final Scheduler scheduler() {
            Scheduler scheduler = AbstractAddon.getScheduler();
            Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"getScheduler(...)");
            return scheduler;
        }

        public final void log(@NotNull Level level, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.getInstance().getLogger().log(level, message);
        }

        public final void log(@NotNull Level level, @NotNull Throwable ex, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.getInstance().getLogger().log(level, ex, () -> Companion.log$lambda$0(message));
        }

        public final void debug(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (configService == null || !this.getConfigService().getDebug()) {
                return;
            }
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            this.log(level, "[DEBUG] " + message);
        }

        private static final String log$lambda$0(String $message) {
            return $message;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

