/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhancraft.libs.guizhanlib.slimefun.addon;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.guizhanss.guizhancraft.libs.guizhanlib.minecraft.localization.MinecraftLocalization;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SlimefunLocalization
extends MinecraftLocalization {
    private static final String KEY_NAME = ".name";
    private static final String KEY_LORE = ".lore";
    private static final String MSG_KEY_NULL = "key cannot be null";
    private static final String MSG_ID_NULL = "id cannot be null";
    private static final String MSG_MATERIAL_NULL = "Material cannot be null";
    private static final String MSG_ITEMSTACK_NULL = "ItemStack cannot be null";
    private static final String MSG_TEXTURE_NULL = "Texture cannot be null";
    private String idPrefix = "";
    private String itemGroupKey = "categories";
    private String itemsKey = "items";
    private String recipesKey = "recipes";

    @ParametersAreNonnullByDefault
    public SlimefunLocalization(JavaPlugin plugin) {
        super(plugin);
    }

    @ParametersAreNonnullByDefault
    public SlimefunLocalization(JavaPlugin plugin, String folderName) {
        super(plugin, folderName);
    }

    @ParametersAreNonnullByDefault
    public SlimefunLocalization(JavaPlugin plugin, String folderName, String langFile) {
        super(plugin, folderName, langFile);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemBy(String key, String id, Material material, String ... extraLore) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)MSG_MATERIAL_NULL);
        return this.getItemBy(key, id, new ItemStack(material), extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemBy(String key, String id, String texture, String ... extraLore) {
        return this.getItemBy(key, id, SlimefunUtils.getCustomHead((String)texture), extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemBy(String key, String id, ItemStack itemStack, String ... extraLore) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)MSG_KEY_NULL);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_ID_NULL);
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)MSG_ITEMSTACK_NULL);
        List<String> lore = this.getStringList(key + "." + id + KEY_LORE);
        Collections.addAll(lore, extraLore);
        return new SlimefunItemStack((this.idPrefix + id).toUpperCase(Locale.ROOT), itemStack, this.getString(key + "." + id + KEY_NAME), (String[])lore.toArray(String[]::new));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemGroupItem(String id, Material material) {
        return this.getItemBy(this.itemGroupKey, id, material, new String[0]);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemGroupItem(String id, String texture) {
        return this.getItemBy(this.itemGroupKey, id, texture, new String[0]);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemGroupItem(String id, ItemStack itemStack) {
        return this.getItemBy(this.itemGroupKey, id, itemStack, new String[0]);
    }

    public SlimefunItemStack getItem(String id, Material material, String ... extraLore) {
        return this.getItemBy(this.itemsKey, id, material, extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItem(String id, String texture, String ... extraLore) {
        return this.getItemBy(this.itemsKey, id, texture, extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItem(String id, ItemStack itemStack, String ... extraLore) {
        return this.getItemBy(this.itemsKey, id, itemStack, extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public RecipeType getRecipeType(String id, Material material, String ... extraLore) {
        return new RecipeType(new NamespacedKey((Plugin)this.getPlugin(), id), this.getItemBy(this.recipesKey, id, material, extraLore), new String[0]);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public RecipeType getRecipeType(String id, String texture, String ... extraLore) {
        return new RecipeType(new NamespacedKey((Plugin)this.getPlugin(), id), this.getItemBy(this.recipesKey, id, texture, extraLore), new String[0]);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public RecipeType getRecipeType(String id, ItemStack itemStack, String ... extraLore) {
        return new RecipeType(new NamespacedKey((Plugin)this.getPlugin(), id), this.getItemBy(this.recipesKey, id, itemStack, extraLore), new String[0]);
    }

    @Generated
    public String getIdPrefix() {
        return this.idPrefix;
    }

    @Generated
    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    @Generated
    public void setItemGroupKey(String itemGroupKey) {
        this.itemGroupKey = itemGroupKey;
    }

    @Generated
    public void setItemsKey(String itemsKey) {
        this.itemsKey = itemsKey;
    }

    @Generated
    public void setRecipesKey(String recipesKey) {
        this.recipesKey = recipesKey;
    }
}

