/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhancraft.core.services;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.guizhanss.guizhancraft.GuizhanCraft;
import net.guizhanss.guizhancraft.libs.guizhanlib.kt.slimefun.items.SlimefunItemStackExtKt;
import net.guizhanss.guizhancraft.libs.guizhanlib.kt.slimefun.items.builder.MaterialType;
import net.guizhanss.guizhancraft.libs.guizhanlib.minecraft.utils.ChatUtil;
import net.guizhanss.guizhancraft.libs.guizhanlib.slimefun.addon.SlimefunLocalization;
import net.guizhanss.guizhancraft.utils.FileUtilsKt;
import net.guizhanss.guizhancraft.utils.GeneralUtilsKt;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J+\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e\"\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J+\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e\"\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\u0018\u001a\u00020\u000bJ/\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lnet/guizhanss/guizhancraft/core/services/LocalizationService;", "Lnet/guizhanss/guizhancraft/libs/guizhanlib/slimefun/addon/SlimefunLocalization;", "plugin", "Lnet/guizhanss/guizhancraft/GuizhanCraft;", "jarFile", "Ljava/io/File;", "<init>", "(Lnet/guizhanss/guizhancraft/GuizhanCraft;Ljava/io/File;)V", "extractTranslations", "", "getString", "", "key", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getItemGroupItem", "Lorg/bukkit/inventory/ItemStack;", "materialType", "Lnet/guizhanss/guizhancraft/libs/guizhanlib/kt/slimefun/items/builder/MaterialType;", "getRecipeTypeItem", "getUIItem", "getItemName", "itemId", "getItemLore", "", "sendMessage", "sender", "Lorg/bukkit/command/CommandSender;", "(Lorg/bukkit/command/CommandSender;Ljava/lang/String;[Ljava/lang/Object;)V", "Companion", "GuizhanCraft"})
public final class LocalizationService
extends SlimefunLocalization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GuizhanCraft plugin;
    @NotNull
    private final File jarFile;
    @NotNull
    public static final String FOLDER_NAME = "lang";

    public LocalizationService(@NotNull GuizhanCraft plugin, @NotNull File jarFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        super(plugin);
        this.plugin = plugin;
        this.jarFile = jarFile;
        this.extractTranslations();
    }

    private final void extractTranslations() {
        File translationsFolder = new File(this.plugin.getDataFolder(), FOLDER_NAME);
        if (!translationsFolder.exists()) {
            translationsFolder.mkdirs();
        }
        List<String> translationFiles = FileUtilsKt.listYmlFilesInJar(this.jarFile, FOLDER_NAME);
        for (String translationFile : translationFiles) {
            String filePath = FOLDER_NAME + File.separator + translationFile;
            this.plugin.saveResource(filePath, true);
        }
    }

    @NotNull
    public final String getString(@NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = MessageFormat.format(this.getString(key), Arrays.copyOf(args, args.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final ItemStack getItemGroupItem(@NotNull String key, @NotNull MaterialType materialType) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)materialType, (String)"materialType");
        SlimefunItemStack slimefunItemStack = this.getItem("GROUP_" + GeneralUtilsKt.toId(key), materialType.convert(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)slimefunItemStack, (String)"getItem(...)");
        return SlimefunItemStackExtKt.toItem(slimefunItemStack);
    }

    @NotNull
    public final ItemStack getRecipeTypeItem(@NotNull String key, @NotNull MaterialType materialType) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)materialType, (String)"materialType");
        SlimefunItemStack slimefunItemStack = this.getItem("RECIPE_" + GeneralUtilsKt.toId(key), materialType.convert(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)slimefunItemStack, (String)"getItem(...)");
        return SlimefunItemStackExtKt.toItem(slimefunItemStack);
    }

    @NotNull
    public final ItemStack getUIItem(@NotNull String key, @NotNull MaterialType materialType) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)materialType, (String)"materialType");
        SlimefunItemStack slimefunItemStack = this.getItem("UI_" + GeneralUtilsKt.toId(key), materialType.convert(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)slimefunItemStack, (String)"getItem(...)");
        return SlimefunItemStackExtKt.toItem(slimefunItemStack);
    }

    @NotNull
    public final String getItemName(@NotNull String itemId, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.getString("items." + GeneralUtilsKt.toId(itemId) + ".name", Arrays.copyOf(args, args.length));
    }

    @NotNull
    public final List<String> getItemLore(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        List<String> list = this.getStringList("items." + GeneralUtilsKt.toId(itemId) + ".lore");
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStringList(...)");
        return list;
    }

    public final void sendMessage(@NotNull CommandSender sender, @NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (GuizhanCraft.Companion.getIntegrationService().getSlimefunTranslationEnabled()) {
            GuizhanCraft.Companion.getIntegrationService().sendMessage(sender, key, Arrays.copyOf(args, args.length));
        } else {
            ChatUtil.send(sender, MessageFormat.format(this.getString("messages." + key), Arrays.copyOf(args, args.length)), new Object[0]);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/guizhanss/guizhancraft/core/services/LocalizationService$Companion;", "", "<init>", "()V", "FOLDER_NAME", "", "GuizhanCraft"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

