/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhancraft.libs.guizhanlib.updater;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.guizhanss.guizhancraft.libs.guizhanlib.updater.GuizhanBuildsUpdaterTask;
import net.guizhanss.guizhancraft.libs.guizhanlib.updater.UpdaterConfig;
import org.bukkit.plugin.Plugin;

public final class GuizhanBuildsUpdater {
    private final Plugin plugin;
    private final File file;
    private final String owner;
    private final String repository;
    private final String branch;
    private final UpdaterConfig updaterConfig;

    @ParametersAreNonnullByDefault
    public static void start(Plugin plugin, File file, String owner, String repository, String branch) {
        GuizhanBuildsUpdater.start(plugin, file, owner, repository, branch, UpdaterConfig.DEFAULT);
    }

    @ParametersAreNonnullByDefault
    public static void start(Plugin plugin, File file, String owner, String repository, String branch, UpdaterConfig updaterConfig) {
        Preconditions.checkNotNull((Object)plugin);
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)branch);
        Preconditions.checkNotNull((Object)updaterConfig);
        GuizhanBuildsUpdaterTask task = new GuizhanBuildsUpdaterTask(new GuizhanBuildsUpdater(plugin, file, owner, repository, branch, updaterConfig));
        task.runTaskLater(plugin, 1L);
    }

    private GuizhanBuildsUpdater(Plugin plugin, File file, String owner, String repository, String branch, UpdaterConfig updaterConfig) {
        this.plugin = plugin;
        this.file = file;
        this.owner = owner;
        this.repository = repository;
        this.branch = branch;
        this.updaterConfig = updaterConfig;
    }

    void log(Level level, String message, Object ... args) {
        this.plugin.getLogger().log(level, String.format(message, args));
    }

    void log(Level level, Throwable throwable, String message, Object ... args) {
        this.plugin.getLogger().log(level, throwable, () -> String.format(message, args));
    }

    @Generated
    Plugin getPlugin() {
        return this.plugin;
    }

    @Generated
    File getFile() {
        return this.file;
    }

    @Generated
    String getOwner() {
        return this.owner;
    }

    @Generated
    String getRepository() {
        return this.repository;
    }

    @Generated
    String getBranch() {
        return this.branch;
    }

    @Generated
    UpdaterConfig getUpdaterConfig() {
        return this.updaterConfig;
    }
}

