/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhancraft.integrations;

import java.util.function.Consumer;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.guizhanss.guizhancraft.GuizhanCraft;
import net.guizhanss.guizhancraft.implementation.setup.ItemSetup;
import net.guizhanss.guizhancraft.implementation.setup.ResearchSetup;
import org.bukkit.plugin.Plugin;

public final class IntegrationsManager {
    private final GuizhanCraft plugin;
    private boolean isEnabled = false;
    private boolean isElectricSpawnersEnabled = false;

    public IntegrationsManager(GuizhanCraft plugin) {
        this.plugin = plugin;
    }

    public void start() {
        if (this.isEnabled) {
            throw new UnsupportedOperationException("Integrations has been loaded.");
        }
        this.isEnabled = true;
        this.onPluginStart();
        this.postIntegration();
    }

    private void onPluginStart() {
        this.load("ElectricSpawners", plugin -> {
            this.isElectricSpawnersEnabled = true;
        });
    }

    private void postIntegration() {
        if (this.isElectricSpawnersEnabled) {
            ItemSetup.setupElectricSpawners();
            ResearchSetup.setupElectricSpawners();
        }
    }

    @ParametersAreNonnullByDefault
    private void load(String pluginName, Consumer<Plugin> consumer) {
        Plugin integration = this.plugin.getServer().getPluginManager().getPlugin(pluginName);
        if (integration != null && integration.isEnabled()) {
            String version = integration.getDescription().getVersion();
            GuizhanCraft.getLocalization().sendConsole("loaded_integration", pluginName, version);
            try {
                consumer.accept(integration);
            }
            catch (Exception | LinkageError x) {
                GuizhanCraft.log(Level.WARNING, "Maybe you need to update {0} or GuizhanCraft?", pluginName);
                GuizhanCraft.log(Level.WARNING, x, "Failed to setup integration of plugin {0}", pluginName);
            }
        }
    }

    @Generated
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Generated
    public boolean isElectricSpawnersEnabled() {
        return this.isElectricSpawnersEnabled;
    }
}

