/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhancraft.implementation.items.machine;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.RepairedSpawner;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import net.guizhanss.guizhancraft.GuizhanCraft;
import net.guizhanss.guizhancraft.implementation.GuizhanCraftItems;
import net.guizhanss.guizhancraft.libs.guizhanlib.slimefun.machines.MenuBlock;
import net.guizhanss.guizhancraft.utils.Debug;
import net.guizhanss.guizhancraft.utils.GuiItems;
import net.guizhanss.guizhancraft.utils.Utils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class ElectricSpawnerAssembler
extends MenuBlock {
    private static final int[] BACKGROUND = new int[]{0, 4, 8, 9, 17, 18, 20, 26, 27, 28, 29, 33, 34, 35, 36, 37, 38, 42, 43, 44, 45, 46, 47, 51, 52, 53};
    private static final int[] INPUT_BACKGROUND = new int[]{1, 2, 3, 5, 6, 7, 10, 12, 14, 16, 19, 20, 21, 23, 24, 25};
    private static final int[] OUTPUT_BACKGROUND = new int[]{30, 31, 32, 39, 41, 48, 49, 50};
    private static final int INPUT_FRAMEWORK_SLOT = 11;
    private static final int INPUT_SPAWNER_SLOT = 15;
    private static final int OUTPUT_SLOT = 40;
    private static final int INFO_SLOT = 13;
    private static final int CRAFT_BUTTON = 22;

    public ElectricSpawnerAssembler(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    protected void setup(BlockMenuPreset blockMenuPreset) {
        blockMenuPreset.drawBackground(ChestMenuUtils.getBackground(), BACKGROUND);
        blockMenuPreset.drawBackground(ChestMenuUtils.getInputSlotTexture(), INPUT_BACKGROUND);
        blockMenuPreset.drawBackground(ChestMenuUtils.getOutputSlotTexture(), OUTPUT_BACKGROUND);
        blockMenuPreset.addItem(13, GuiItems.ELECTRIC_SPAWNER_ASSEMBLER_INFO);
        blockMenuPreset.addItem(22, GuiItems.CRAFT);
        blockMenuPreset.addMenuClickHandler(13, ChestMenuUtils.getEmptyClickHandler());
        blockMenuPreset.addMenuClickHandler(22, ChestMenuUtils.getEmptyClickHandler());
    }

    @Override
    protected int[] getInputSlots() {
        return new int[]{11, 15};
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[]{40};
    }

    @Override
    protected void onBreak(@Nonnull BlockBreakEvent e, @Nonnull BlockMenu menu) {
        super.onBreak(e, menu);
        Location location = menu.getLocation();
        menu.dropItems(location, this.getInputSlots());
        menu.dropItems(location, this.getOutputSlots());
    }

    @Override
    protected void onNewInstance(@Nonnull BlockMenu blockMenu, @Nonnull Block b) {
        super.onNewInstance(blockMenu, b);
        blockMenu.addMenuClickHandler(22, (player, i, itemStack, clickAction) -> {
            this.manualCraft(blockMenu, player);
            return false;
        });
    }

    private void manualCraft(@Nonnull BlockMenu blockMenu, @Nonnull Player p) {
        if (this.craft(blockMenu)) {
            String itemName = ItemUtils.getItemName((ItemStack)blockMenu.getItemInSlot(40));
            GuizhanCraft.getLocalization().sendMessage(p, "crafted", itemName);
        } else {
            GuizhanCraft.getLocalization().sendMessage(p, "not-crafted", new Object[0]);
        }
    }

    private boolean craft(@Nonnull BlockMenu blockMenu) {
        ItemStack framework = blockMenu.getItemInSlot(11);
        ItemStack spawner = blockMenu.getItemInSlot(15);
        ItemStack output = blockMenu.getItemInSlot(40);
        if (!this.validateInput(framework, spawner)) {
            return false;
        }
        RepairedSpawner repairedSpawner = (RepairedSpawner)SlimefunItem.getByItem((ItemStack)spawner);
        Optional entityType = repairedSpawner.getEntityType(spawner);
        if (entityType.isEmpty()) {
            return false;
        }
        Debug.log("Got entity type", new Object[0]);
        EntityType type = (EntityType)entityType.get();
        SlimefunItem electricSpawner = SlimefunItem.getById((String)("ELECTRIC_SPAWNER_" + String.valueOf(type)));
        if (electricSpawner == null) {
            return false;
        }
        Debug.log("Got electric spawner", new Object[0]);
        if (Utils.checkItemStack(output) && !SlimefunUtils.isItemSimilar((ItemStack)output, (ItemStack)electricSpawner.getItem(), (boolean)false, (boolean)false)) {
            return false;
        }
        Debug.log("Output slot is available", new Object[0]);
        blockMenu.consumeItem(11, 1);
        blockMenu.consumeItem(15, 1);
        blockMenu.pushItem(electricSpawner.getItem().clone(), new int[]{40});
        return true;
    }

    @ParametersAreNullableByDefault
    private boolean validateInput(ItemStack framework, ItemStack spawner) {
        Debug.log("Start input validation!", new Object[0]);
        if (!Utils.checkItemStack(framework)) {
            return false;
        }
        if (!SlimefunUtils.isItemSimilar((ItemStack)framework, (ItemStack)GuizhanCraftItems.ELECTRIC_SPAWNER_FRAMEWORK, (boolean)false, (boolean)false)) {
            return false;
        }
        Debug.log("Checked framework!", new Object[0]);
        if (!Utils.checkItemStack(spawner)) {
            return false;
        }
        SlimefunItem repairedSpawner = SlimefunItem.getByItem((ItemStack)spawner);
        Debug.log("Is RepairedSpawner? " + (repairedSpawner instanceof RepairedSpawner), new Object[0]);
        return repairedSpawner instanceof RepairedSpawner;
    }
}

