/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhancraft.libs.guizhanlib.minecraft.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.guizhanss.guizhancraft.libs.guizhanlib.minecraft.utils.ChatUtil;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public final class ItemUtil {
    public static <T extends ItemStack> T appendLore(@Nonnull T itemStack, String ... extraLore) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        if (extraLore == null || extraLore.length == 0) {
            return itemStack;
        }
        return ItemUtil.appendLore(itemStack, Arrays.asList(extraLore));
    }

    public static <T extends ItemStack> T appendLore(@Nonnull T itemStack, @Nonnull List<String> extraLore) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        Preconditions.checkArgument((extraLore != null ? 1 : 0) != 0, (Object)"extraLore cannot be null");
        ItemMeta meta = itemStack.getItemMeta();
        List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        lore.addAll(ChatUtil.color(extraLore));
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static boolean isValid(@Nullable ItemStack itemStack) {
        return itemStack != null && !itemStack.getType().isAir();
    }

    @Nonnull
    public static ItemStack removeDamage(@Nonnull ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Item cannot be null");
        ItemStack clone = item.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(0);
            clone.setItemMeta(meta);
        }
        return clone;
    }

    public static boolean canStack(@Nullable ItemStack a, @Nullable ItemStack b) {
        if (a != null && b != null) {
            if (a.getType() == b.getType() && a.hasItemMeta() == b.hasItemMeta()) {
                if (a.hasItemMeta()) {
                    LeatherArmorMeta leatherArmorMeta;
                    Damageable damageable;
                    ItemMeta bMeta;
                    ItemMeta aMeta = a.getItemMeta();
                    if (aMeta instanceof Damageable != (bMeta = b.getItemMeta()) instanceof Damageable) {
                        return false;
                    }
                    if (aMeta instanceof Damageable && (damageable = (Damageable)aMeta).getDamage() != ((Damageable)bMeta).getDamage()) {
                        return false;
                    }
                    if (aMeta instanceof LeatherArmorMeta != bMeta instanceof LeatherArmorMeta) {
                        return false;
                    }
                    if (aMeta instanceof LeatherArmorMeta && !(leatherArmorMeta = (LeatherArmorMeta)aMeta).getColor().equals((Object)((LeatherArmorMeta)bMeta).getColor())) {
                        return false;
                    }
                    if (aMeta.hasCustomModelData() != bMeta.hasCustomModelData()) {
                        return false;
                    }
                    if (aMeta.hasCustomModelData() && aMeta.getCustomModelData() != bMeta.getCustomModelData()) {
                        return false;
                    }
                    if (!aMeta.getPersistentDataContainer().equals((Object)bMeta.getPersistentDataContainer())) {
                        return false;
                    }
                    if (!aMeta.getEnchants().equals(bMeta.getEnchants())) {
                        return false;
                    }
                    if (aMeta.hasDisplayName() != bMeta.hasDisplayName()) {
                        return false;
                    }
                    if (aMeta.hasDisplayName() && !aMeta.getDisplayName().equals(bMeta.getDisplayName())) {
                        return false;
                    }
                    if (aMeta.hasLore() != bMeta.hasLore()) {
                        return false;
                    }
                    if (aMeta.hasLore()) {
                        List aLore = aMeta.getLore();
                        List bLore = bMeta.getLore();
                        if (aLore.size() != bLore.size()) {
                            return false;
                        }
                        for (int i = 0; i < aLore.size(); ++i) {
                            if (((String)aLore.get(i)).equals(bLore.get(i))) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Generated
    private ItemUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

