/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhancraft.core.services;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhancraft.GuizhanCraft;
import net.guizhanss.guizhancraft.libs.guizhanlib.common.utils.StringUtil;
import net.guizhanss.guizhancraft.libs.guizhanlib.localization.Localization;
import net.guizhanss.guizhancraft.libs.guizhanlib.minecraft.utils.ChatUtil;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class LocalizationService
extends Localization {
    public LocalizationService(GuizhanCraft plugin) {
        super(plugin);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public String getString(String key, Object ... args) {
        return MessageFormat.format(this.getString(key), args);
    }

    @Nonnull
    public String getCategoryName(@Nonnull String categoryId) {
        Preconditions.checkArgument((categoryId != null ? 1 : 0) != 0, (Object)"Category id cannot be null");
        return this.getString("categories." + StringUtil.dehumanize(categoryId).toLowerCase(Locale.ROOT));
    }

    @Nonnull
    public String getItemName(@Nonnull String itemId) {
        Preconditions.checkArgument((itemId != null ? 1 : 0) != 0, (Object)"Item id cannot be null");
        return this.getString("items." + StringUtil.dehumanize(itemId).toLowerCase(Locale.ROOT) + ".name");
    }

    @Nonnull
    public String[] getItemLore(@Nonnull String itemId) {
        Preconditions.checkArgument((itemId != null ? 1 : 0) != 0, (Object)"Item id cannot be null");
        return this.getStringArray("items." + StringUtil.dehumanize(itemId).toLowerCase(Locale.ROOT) + ".lore");
    }

    @Nonnull
    public String getRecipeTypeName(@Nonnull String recipeTypeId) {
        Preconditions.checkArgument((recipeTypeId != null ? 1 : 0) != 0, (Object)"RecipeType id cannot be null");
        return this.getString("recipes." + StringUtil.dehumanize(recipeTypeId).toLowerCase(Locale.ROOT) + ".name");
    }

    @Nonnull
    public String[] getRecipeTypeLore(@Nonnull String recipeTypeId) {
        Preconditions.checkArgument((recipeTypeId != null ? 1 : 0) != 0, (Object)"RecipeType id cannot be null");
        return this.getStringArray("recipes." + StringUtil.dehumanize(recipeTypeId).toLowerCase(Locale.ROOT) + ".lore");
    }

    @Nonnull
    public String getLore(@Nonnull String loreId) {
        Preconditions.checkArgument((loreId != null ? 1 : 0) != 0, (Object)"lore id cannot be null");
        return this.getString("lores." + StringUtil.dehumanize(loreId).toLowerCase(Locale.ROOT));
    }

    @Nonnull
    public String getResearchName(@Nonnull String researchId) {
        Preconditions.checkArgument((researchId != null ? 1 : 0) != 0, (Object)"Research Id cannot be null");
        return this.getString("researches." + StringUtil.dehumanize(researchId).toLowerCase(Locale.ROOT));
    }

    @ParametersAreNonnullByDefault
    public <T extends CommandSender> void send(T sender, String key, Object ... args) {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"sender cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        ChatUtil.send(sender, MessageFormat.format(this.getString(key), args), new Object[0]);
    }

    @ParametersAreNonnullByDefault
    public <T extends CommandSender> void sendMessage(T sender, String messageKey, Object ... args) {
        Preconditions.checkArgument((messageKey != null ? 1 : 0) != 0, (Object)"Message key cannot be null");
        this.send(sender, "messages." + messageKey, args);
    }

    @ParametersAreNonnullByDefault
    public void sendConsole(String messageKey, Object ... args) {
        Preconditions.checkArgument((messageKey != null ? 1 : 0) != 0, (Object)"Message key cannot be null");
        GuizhanCraft.sendConsole(this.getString("console." + messageKey), args);
    }

    @ParametersAreNonnullByDefault
    public void sendActionbarMessage(Player p, String messageKey, Object ... args) {
        Preconditions.checkArgument((p != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        Preconditions.checkArgument((messageKey != null ? 1 : 0) != 0, (Object)"Message key cannot be null");
        String message = MessageFormat.format(this.getString("messages." + messageKey), args);
        BaseComponent[] components = TextComponent.fromLegacyText((String)ChatUtil.color(message));
        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
    }
}

