/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhancraft.implementation.commands;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.AbstractMonsterSpawner;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhancraft.GuizhanCraft;
import net.guizhanss.guizhancraft.libs.guizhanlib.minecraft.commands.AbstractCommand;
import net.guizhanss.guizhancraft.libs.guizhanlib.minecraft.commands.BaseCommand;
import net.guizhanss.guizhancraft.libs.guizhanlib.minecraft.commands.SubCommand;
import net.guizhanss.guizhancraft.libs.guizhanlib.minecraft.utils.InventoryUtil;
import net.guizhanss.guizhancraft.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class SfSpanwerCommand
extends BaseCommand {
    @ParametersAreNonnullByDefault
    public SfSpanwerCommand(PluginCommand command) {
        super(command, (AbstractCommand cmd, CommandSender sender) -> GuizhanCraft.getLocalization().getString("commands." + String.valueOf(cmd) + ".description"), "<broken/repaired> <player> <mob_type> [amount]", new SubCommand[0]);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onExecute(CommandSender sender, String[] args) {
        if (!sender.hasPermission("guizhancraft.commands.sfspawner")) {
            GuizhanCraft.getLocalization().sendMessage(sender, "no-permission", new Object[0]);
            return;
        }
        if (args[0].equalsIgnoreCase("broken")) {
            this.giveSpawner(sender, args, false);
        } else if (args[0].equalsIgnoreCase("repaired")) {
            this.giveSpawner(sender, args, true);
        } else {
            this.sendHelp(sender, this.getName());
        }
    }

    @Override
    @Nullable
    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            String[] subcommands = new String[]{"broken", "repaired"};
            return Arrays.asList(subcommands);
        }
        if (args.length == 2) {
            return null;
        }
        if (args.length == 3) {
            return Arrays.stream(EntityType.values()).map(Enum::toString).filter(name -> name.startsWith(args[1])).toList();
        }
        return new ArrayList<String>();
    }

    private void giveSpawner(CommandSender sender, String[] args, boolean isRepaired) {
        EntityType entityType;
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            GuizhanCraft.getLocalization().sendMessage(sender, "player-not-found", args[1]);
            return;
        }
        int amount = Utils.parseIntAndClamp(args.length == 4 ? args[3] : null, 1, 64);
        try {
            entityType = EntityType.valueOf((String)args[2]);
        }
        catch (IllegalArgumentException ex) {
            GuizhanCraft.getLocalization().send(sender, "commands.sfspawner.invalid-entity-type", args[2]);
            return;
        }
        SlimefunItemStack sfItemStack = isRepaired ? SlimefunItems.REPAIRED_SPAWNER : SlimefunItems.BROKEN_SPAWNER;
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)sfItemStack);
        AbstractMonsterSpawner spawnerItem = (AbstractMonsterSpawner)sfItem;
        CustomItemStack spawner = new CustomItemStack(spawnerItem.getItemForEntityType(entityType), amount);
        InventoryUtil.push(target, new ItemStack[]{spawner});
        GuizhanCraft.getLocalization().send(sender, "commands.sfspawner.sent", target.getName(), ItemUtils.getItemName((ItemStack)spawner));
        GuizhanCraft.getLocalization().send(target, "commands.sfspawner.received", sender.getName(), ItemUtils.getItemName((ItemStack)spawner));
    }
}

