/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhancraft;

import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhancraft.core.services.LocalizationService;
import net.guizhanss.guizhancraft.implementation.setup.CommandSetup;
import net.guizhanss.guizhancraft.implementation.setup.ItemSetup;
import net.guizhanss.guizhancraft.implementation.setup.ResearchSetup;
import net.guizhanss.guizhancraft.integrations.IntegrationsManager;
import net.guizhanss.guizhancraft.libs.guizhanlib.slimefun.addon.AbstractAddon;
import net.guizhanss.guizhancraft.libs.guizhanlib.slimefun.addon.AddonConfig;
import net.guizhanss.guizhancraft.libs.guizhanlib.updater.GuizhanBuildsUpdater;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public final class GuizhanCraft
extends AbstractAddon {
    private static final String DEFAULT_LANG = "en-US";
    private static final int CONFIG_VERSION = 2;
    private boolean isDebugEnabled = false;
    private LocalizationService localization;
    private IntegrationsManager integrations;

    public GuizhanCraft() {
        super("ybw0014", "GuizhanCraft", "master", "auto-update");
    }

    @Nonnull
    private static GuizhanCraft inst() {
        return (GuizhanCraft)((Object)GuizhanCraft.getInstance());
    }

    @Nonnull
    public static LocalizationService getLocalization() {
        return GuizhanCraft.inst().localization;
    }

    @Nonnull
    public static IntegrationsManager getIntegrationManager() {
        return GuizhanCraft.inst().integrations;
    }

    @ParametersAreNonnullByDefault
    public static void debug(String message, Object ... args) {
        if (GuizhanCraft.inst().isDebugEnabled) {
            GuizhanCraft.log(Level.WARNING, "[DEBUG] " + message, args);
        }
    }

    @Override
    protected void enable() {
        GuizhanCraft.sendConsole("&a==================", new Object[0]);
        GuizhanCraft.sendConsole("&a   GuizhanCraft   ", new Object[0]);
        GuizhanCraft.sendConsole("&a    by ybw0014    ", new Object[0]);
        GuizhanCraft.sendConsole("&a==================", new Object[0]);
        AddonConfig config = GuizhanCraft.getAddonConfig();
        if (config.getInt("version", 1) < 2) {
            YamlConfiguration defaultConfig = config.getDefaults();
            for (String key : defaultConfig.getKeys(true)) {
                if (config.contains(key)) continue;
                config.set(key, defaultConfig.get(key));
            }
            config.set("version", 2);
            config.save();
        }
        if (config.getBoolean("debug")) {
            this.isDebugEnabled = true;
        }
        String lang = config.getString("lang", DEFAULT_LANG);
        this.localization = new LocalizationService(this);
        this.localization.addLanguage(lang);
        if (!lang.equals(DEFAULT_LANG)) {
            this.localization.addLanguage(DEFAULT_LANG);
        }
        this.localization.sendConsole("loaded_language", lang);
        this.localization.sendConsole("loading_items", new Object[0]);
        ItemSetup.setup();
        this.localization.sendConsole("loading_commands", new Object[0]);
        CommandSetup.setup();
        if (this.getConfig().getBoolean("enable-researches", true)) {
            this.localization.sendConsole("loading_researches", new Object[0]);
            ResearchSetup.setup();
        }
        this.localization.sendConsole("loading_integrations", new Object[0]);
        this.integrations = new IntegrationsManager(this);
        this.integrations.start();
    }

    @Override
    protected void disable() {
    }

    @Override
    protected void autoUpdate() {
        if (this.getPluginVersion().startsWith("Dev")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), this.getGithubRepo()).start();
        } else if (this.getPluginVersion().startsWith("Build")) {
            try {
                char[] pluginPackage = new char[]{'n', 'e', 't', '.', 'g', 'u', 'i', 'z', 'h', 'a', 'n', 's', 's', '.', 'g', 'u', 'i', 'z', 'h', 'a', 'n', 'l', 'i', 'b', 'p', 'l', 'u', 'g', 'i', 'n'};
                Class<?> clazz = Class.forName(new String(pluginPackage) + ".updater.GuizhanUpdater");
                Method updaterStart = clazz.getDeclaredMethod("start", Plugin.class, File.class, String.class, String.class, String.class);
                updaterStart.invoke(null, new Object[]{this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()});
            }
            catch (Exception ignored) {
                GuizhanBuildsUpdater.start((Plugin)this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch());
            }
        }
    }
}

