/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.core.commands.subcommands;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.commands.AbstractSubCommand;
import net.guizhanss.gcereborn.core.commands.subcommands.DnaCompletion;
import net.guizhanss.gcereborn.core.genetics.DNA;
import net.guizhanss.gcereborn.core.genetics.Gene;
import net.guizhanss.gcereborn.libs.guizhanlib.minecraft.commands.AbstractCommand;
import net.guizhanss.gcereborn.libs.guizhanlib.minecraft.commands.SubCommand;
import org.bukkit.command.CommandSender;

public final class CalcChanceCommand
extends AbstractSubCommand
implements DnaCompletion {
    public CalcChanceCommand(@Nonnull AbstractCommand parent) {
        super(parent, "calcchance", "<parent1DNA> <parent2DNA> <childDNA>", new SubCommand[0]);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onExecute(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender)) {
            GeneticChickengineering.getLocalization().sendMessage(sender, "no-permission", new Object[0]);
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (DNA.isValidSequence(args[i])) continue;
            GeneticChickengineering.getLocalization().sendMessage(sender, "invalid-dna-notation", args[i]);
            return;
        }
        DNA p1dna = new DNA(args[0].toCharArray());
        DNA p2dna = new DNA(args[1].toCharArray());
        DNA cdna = new DNA(args[2].toCharArray());
        double chanceTotal = 1.0;
        for (int i = 0; i < 6; ++i) {
            Gene p1g = p1dna.getGene(i);
            Gene p2g = p2dna.getGene(i);
            Gene cg = cdna.getGene(i);
            double matches = 0.0;
            for (char p1a : p1g.getAlleles()) {
                for (char p2a : p2g.getAlleles()) {
                    if (new Gene(new char[]{p1a, p2a}).getState() != cg.getState()) continue;
                    matches += 1.0;
                }
            }
            chanceTotal *= matches * 0.25;
        }
        long readableChance = Math.round(chanceTotal * 100.0);
        GeneticChickengineering.getLocalization().sendMessage(sender, "chance-result", readableChance, p1dna, p2dna, cdna);
    }

    @Override
    @ParametersAreNonnullByDefault
    public List<String> onTab(CommandSender sender, String[] args) {
        return this.tabComplete(sender, args, 0, 1, 2);
    }
}

