/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.utils;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.genetics.DNA;
import net.guizhanss.gcereborn.core.services.LocalizationService;
import net.guizhanss.gcereborn.items.GCEItems;
import net.guizhanss.gcereborn.items.chicken.ChickenTypes;
import net.guizhanss.gcereborn.items.chicken.PocketChicken;
import net.guizhanss.gcereborn.libs.guizhanlib.minecraft.utils.MinecraftVersionUtil;
import net.guizhanss.gcereborn.setup.Groups;
import net.guizhanss.gcereborn.setup.RecipeTypes;
import net.guizhanss.gcereborn.utils.Keys;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Chicken;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public final class ChickenUtils {
    public static boolean isPocketChicken(@Nullable ItemStack item) {
        return item != null && !item.getType().isAir() && item.hasItemMeta() && PersistentDataAPI.hasIntArray((PersistentDataHolder)item.getItemMeta(), (NamespacedKey)Keys.POCKET_CHICKEN_DNA);
    }

    @Nonnull
    public static JsonObject getChickenJson(boolean isBaby) {
        JsonObject json = new JsonObject();
        json.addProperty("_type", "CHICKEN");
        json.addProperty("_health", (Number)4.0);
        json.addProperty("_absorption", (Number)0.0);
        json.addProperty("_removeWhenFarAway", Boolean.valueOf(false));
        json.addProperty("_customName", (String)null);
        json.addProperty("_customNameVisible", Boolean.valueOf(false));
        json.addProperty("_ai", Boolean.valueOf(true));
        json.addProperty("_silent", Boolean.valueOf(false));
        json.addProperty("_glowing", Boolean.valueOf(false));
        json.addProperty("_invulnerable", Boolean.valueOf(false));
        json.addProperty("_collidable", Boolean.valueOf(true));
        json.addProperty("_gravity", Boolean.valueOf(true));
        json.addProperty("_fireTicks", (Number)0);
        json.addProperty("baby", Boolean.valueOf(isBaby));
        json.addProperty("_age", (Number)(isBaby ? -24000 : 6000));
        json.addProperty("_ageLock", Boolean.valueOf(false));
        json.addProperty("_breedable", Boolean.valueOf(false));
        json.addProperty("_loveModeTicks", (Number)0);
        json.add("_attributes", (JsonElement)new JsonObject());
        json.add("_effects", (JsonElement)new JsonObject());
        json.add("_scoreboardTags", (JsonElement)new JsonArray());
        return json;
    }

    @Nonnull
    public static ItemStack capture(@Nonnull Chicken chicken) {
        DNA dna;
        GeneticChickengineering.getIntegrationService().captureChicken(chicken);
        JsonObject json = PocketChicken.ADAPTER.saveData(chicken);
        ItemStack item = GCEItems.POCKET_CHICKEN.item();
        String uuid = chicken.getUniqueId().toString();
        if (PersistentDataAPI.hasString((PersistentDataHolder)chicken, (NamespacedKey)Keys.CHICKEN_DNA)) {
            String dnaStr = PersistentDataAPI.getString((PersistentDataHolder)chicken, (NamespacedKey)Keys.CHICKEN_DNA);
            GeneticChickengineering.debug("captured chicken has data in pdc: {0}", dnaStr);
            dna = new DNA(dnaStr);
        } else {
            GeneticChickengineering.debug("captured chicken has no DNA information", new Object[0]);
            dna = new DNA();
        }
        if (GeneticChickengineering.getConfigService().isDisplayResources() && json.get("_customNameVisible").getAsBoolean() && dna.isKnown()) {
            String name = !json.get("_customName").isJsonNull() ? json.get("_customName").getAsString() : "";
            String replace = "(" + ChickenTypes.getDisplayName(dna.getTyping()) + ")";
            if ((name = name.replace(replace, "")).isEmpty()) {
                json.addProperty("_customName", (String)null);
                json.addProperty("_customNameVisible", Boolean.valueOf(false));
            } else {
                json.addProperty("_customName", name);
            }
        }
        ChickenUtils.setPocketChicken(item, json, dna);
        return item;
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public static ItemStack breed(ItemStack chick1, ItemStack chick2) {
        Preconditions.checkArgument((chick1 != null ? 1 : 0) != 0, (Object)"chick1 cannot be null");
        Preconditions.checkArgument((chick2 != null ? 1 : 0) != 0, (Object)"chick2 cannot be null");
        ItemMeta c1m = chick1.getItemMeta();
        ItemMeta c2m = chick2.getItemMeta();
        if (PersistentDataAPI.hasIntArray((PersistentDataHolder)c1m, (NamespacedKey)Keys.POCKET_CHICKEN_DNA) && PersistentDataAPI.hasIntArray((PersistentDataHolder)c2m, (NamespacedKey)Keys.POCKET_CHICKEN_DNA)) {
            DNA c1d = new DNA(PersistentDataAPI.getIntArray((PersistentDataHolder)c1m, (NamespacedKey)Keys.POCKET_CHICKEN_DNA));
            DNA c2d = new DNA(PersistentDataAPI.getIntArray((PersistentDataHolder)c2m, (NamespacedKey)Keys.POCKET_CHICKEN_DNA));
            return ChickenUtils.fromDNA(new DNA(c1d.split(), c2d.split()), true);
        }
        return null;
    }

    public static void createProductDisplay(int typing) {
        ItemStack fake = GCEItems.POCKET_CHICKEN.item();
        DNA dna = new DNA(typing);
        String productRawName = ChickenTypes.getName(typing);
        ChickenUtils.setPocketChicken(fake, null, dna);
        String itemIDType = productRawName.replace(" ", "_").toUpperCase();
        SlimefunItemStack displayItem = new SlimefunItemStack("GCE_" + itemIDType + "_CHICKEN_ICON", ChickenTypes.getProduct(typing));
        ItemMeta meta = displayItem.getItemMeta();
        PersistentDataAPI.setIntArray((PersistentDataHolder)meta, (NamespacedKey)Keys.POCKET_CHICKEN_DNA, (int[])dna.getState());
        displayItem.setItemMeta(meta);
        new PocketChicken(Groups.DICTIONARY, displayItem, RecipeTypes.FROM_CHICKEN, new ItemStack[]{null, null, null, null, fake, null, null, null, null}).register((SlimefunAddon)GeneticChickengineering.getInstance());
    }

    @Nonnull
    public static ItemStack fromDNA(@Nonnull DNA dna, boolean isBaby) {
        JsonObject json = ChickenUtils.getChickenJson(isBaby);
        ItemStack item = GCEItems.POCKET_CHICKEN.item();
        ChickenUtils.setPocketChicken(item, json, dna);
        return item;
    }

    @Nonnull
    public static DNA getDNA(@Nonnull ItemStack chicken) {
        ItemMeta meta = chicken.getItemMeta();
        return new DNA(PersistentDataAPI.getIntArray((PersistentDataHolder)meta, (NamespacedKey)Keys.POCKET_CHICKEN_DNA));
    }

    public static int getDNAStrength(@Nonnull ItemStack chicken) {
        DNA dna = ChickenUtils.getDNA(chicken);
        int[] state = dna.getState();
        int str = 6 - dna.getTier();
        for (int i = 0; i < 6; ++i) {
            if (state[i] != 1) continue;
            --str;
        }
        return str;
    }

    @Nonnull
    private static List<String> getLore(@Nullable JsonObject json, @Nonnull DNA dna) {
        LinkedList<String> lore = new LinkedList();
        LocalizationService localization = GeneticChickengineering.getLocalization();
        if (json != null) {
            lore = PocketChicken.ADAPTER.getLore(json);
            if (GeneticChickengineering.getConfigService().isPainEnabled()) {
                double health = json.get("_health").getAsDouble();
                String status = health > 2.0 ? localization.getString("lores.chicken.status.healthy") : (health <= 0.5 ? localization.getString("lores.chicken.status.exhausted") : localization.getString("lores.chicken.status.fatigued"));
                lore.add(localization.getString("lores.chicken.status.line", status));
            }
        }
        if (dna.isKnown()) {
            lore.add(localization.getString("lores.chicken.dna", dna));
            lore.add(localization.getString("lores.chicken.type", ChickenTypes.getDisplayName(dna.getTyping())));
        }
        return lore;
    }

    public static void setPocketChicken(@Nonnull ItemStack item, @Nullable JsonObject json, @Nonnull DNA dna) {
        ItemMeta meta = item.getItemMeta();
        PersistentDataAPI.setIntArray((PersistentDataHolder)meta, (NamespacedKey)Keys.POCKET_CHICKEN_DNA, (int[])dna.getState());
        if (json != null) {
            PersistentDataAPI.set((PersistentDataHolder)meta, (NamespacedKey)Keys.POCKET_CHICKEN_ADAPTER, PocketChicken.ADAPTER, (Object)json);
        }
        meta.setLore(ChickenUtils.getLore(json, dna));
        item.setItemMeta(meta);
    }

    public static double getHealth(@Nullable ItemStack chicken) {
        if (chicken == null || chicken.getType().isAir()) {
            return 0.0;
        }
        ItemMeta meta = chicken.getItemMeta();
        JsonObject json = (JsonObject)PersistentDataAPI.get((PersistentDataHolder)meta, (NamespacedKey)Keys.POCKET_CHICKEN_ADAPTER, PocketChicken.ADAPTER);
        if (json != null) {
            return json.get("_health").getAsDouble();
        }
        return 0.0;
    }

    public static boolean survivesPain(@Nullable ItemStack chicken) {
        return ChickenUtils.getHealth(chicken) > 0.25;
    }

    public static boolean harm(@Nullable ItemStack chicken) {
        return ChickenUtils.harm(chicken, 0.25);
    }

    public static boolean harm(@Nullable ItemStack chicken, double damage) {
        if (chicken == null || chicken.getType().isAir()) {
            return false;
        }
        ItemMeta meta = chicken.getItemMeta();
        JsonObject json = (JsonObject)PersistentDataAPI.get((PersistentDataHolder)meta, (NamespacedKey)Keys.POCKET_CHICKEN_ADAPTER, PocketChicken.ADAPTER);
        if (json != null) {
            double oldHealth = json.get("_health").getAsDouble();
            double newHealth = Math.max(0.0, Math.min(oldHealth - damage, 4.0));
            json.addProperty("_health", (Number)newHealth);
            ChickenUtils.setPocketChicken(chicken, json, ChickenUtils.getDNA(chicken));
            return true;
        }
        return false;
    }

    public static boolean heal(@Nullable ItemStack chicken, double amount) {
        if (amount > 0.0) {
            amount *= -1.0;
        }
        return ChickenUtils.harm(chicken, amount);
    }

    public static void possiblyHarm(@Nullable ItemStack chicken) {
        if ((double)ThreadLocalRandom.current().nextInt(100) < GeneticChickengineering.getConfigService().getPainChance()) {
            ChickenUtils.harm(chicken);
        }
    }

    @Nonnull
    public static ItemStack getResource(@Nonnull ItemStack chicken) {
        DNA dna = ChickenUtils.getDNA(chicken);
        return ChickenTypes.getProduct(dna.getTyping());
    }

    public static int getResourceTier(@Nonnull ItemStack chicken) {
        DNA dna = ChickenUtils.getDNA(chicken);
        return dna.getTier();
    }

    public static boolean isFood(@Nullable ItemStack item) {
        if (item == null || item.getType().isAir() || item.hasItemMeta()) {
            return false;
        }
        Material type = item.getType();
        if (type == Material.WHEAT_SEEDS || type == Material.BEETROOT_SEEDS || type == Material.MELON_SEEDS || type == Material.PUMPKIN_SEEDS) {
            return true;
        }
        if (MinecraftVersionUtil.isAtLeast(19, 4) && type == Material.TORCHFLOWER_SEEDS) {
            return true;
        }
        return MinecraftVersionUtil.isAtLeast(20) && type == Material.PITCHER_POD;
    }

    public static boolean isAdult(@Nonnull ItemStack chicken) {
        JsonObject json = (JsonObject)PersistentDataAPI.get((PersistentDataHolder)chicken.getItemMeta(), (NamespacedKey)Keys.POCKET_CHICKEN_ADAPTER, PocketChicken.ADAPTER);
        if (json != null) {
            return !json.get("baby").getAsBoolean();
        }
        return false;
    }

    public static boolean isLearned(@Nonnull ItemStack chicken) {
        DNA dna = ChickenUtils.getDNA(chicken);
        return dna.isKnown();
    }

    @Nonnull
    public static ItemStack learnDNA(@Nonnull ItemStack chicken) {
        ItemStack item = chicken.clone();
        ItemMeta meta = item.getItemMeta();
        if (PersistentDataAPI.hasIntArray((PersistentDataHolder)meta, (NamespacedKey)Keys.POCKET_CHICKEN_DNA)) {
            DNA dna = new DNA(PersistentDataAPI.getIntArray((PersistentDataHolder)meta, (NamespacedKey)Keys.POCKET_CHICKEN_DNA));
            dna.learn();
            JsonObject json = (JsonObject)PersistentDataAPI.get((PersistentDataHolder)meta, (NamespacedKey)Keys.POCKET_CHICKEN_ADAPTER, PocketChicken.ADAPTER);
            ChickenUtils.setPocketChicken(item, json, dna);
        }
        return item;
    }

    @Generated
    private ChickenUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

