/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.libs.guizhanlib.minecraft.commands;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.guizhanss.gcereborn.libs.guizhanlib.minecraft.commands.BaseCommand;
import net.guizhanss.gcereborn.libs.guizhanlib.minecraft.commands.SubCommand;
import net.guizhanss.gcereborn.libs.guizhanlib.minecraft.commands.Usage;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public abstract class AbstractCommand {
    private final Set<SubCommand> subCommands = new HashSet<SubCommand>();
    private final AbstractCommand parent;
    private final String name;
    private final BiFunction<AbstractCommand, CommandSender, String> description;
    private final Usage usage;

    protected AbstractCommand(@Nullable AbstractCommand parent, @Nonnull String name, @Nonnull BiFunction<AbstractCommand, CommandSender, String> description, @Nonnull String usage, SubCommand ... subCommands) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"name cannot be null or empty");
        Preconditions.checkArgument((description != null ? 1 : 0) != 0, (Object)"description cannot be null");
        this.parent = parent;
        this.name = name;
        this.description = description;
        this.usage = new Usage(usage);
        this.subCommands.addAll(Set.of(subCommands));
    }

    @ParametersAreNonnullByDefault
    protected AbstractCommand(String name, BiFunction<AbstractCommand, CommandSender, String> description, String usage, SubCommand ... subCommands) {
        this(null, name, description, usage, subCommands);
    }

    @Nonnull
    public AbstractCommand addSubCommand(SubCommand ... subCommands) {
        this.subCommands.addAll(Set.of(subCommands));
        return this;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean hasSubCommands() {
        return !this.subCommands.isEmpty();
    }

    @ParametersAreNonnullByDefault
    protected final void onCommandExecute(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasSubCommands()) {
            if (this.getUsage().isValid(args)) {
                this.onExecute(sender, args);
            } else {
                this.sendHelp(sender, label);
            }
        } else if (args.length == 0) {
            this.sendHelp(sender, label);
        } else {
            for (SubCommand subCommand : this.getSubCommands()) {
                if (!subCommand.getName().equalsIgnoreCase(args[0])) continue;
                subCommand.onCommandExecute(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
                return;
            }
            this.sendHelp(sender, label);
        }
    }

    @Nullable
    @ParametersAreNonnullByDefault
    protected final List<String> onTabCompleteExecute(CommandSender sender, String[] args) {
        if (this.hasSubCommands()) {
            if (args.length == 1) {
                return this.getSubCommands().stream().map(AbstractCommand::getName).toList();
            }
            for (SubCommand subCommand : this.getSubCommands()) {
                if (!subCommand.getName().equalsIgnoreCase(args[0])) continue;
                return subCommand.onTabCompleteExecute(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            return List.of();
        }
        return this.onTab(sender, args);
    }

    @Nonnull
    public String getFullUsage(@Nonnull String label) {
        ArrayDeque<AbstractCommand> layers = new ArrayDeque<AbstractCommand>();
        for (AbstractCommand current = this; current != null; current = current.getParent()) {
            layers.push(current);
        }
        Object cmd = layers.stream().map(command -> command instanceof BaseCommand ? label : command.getName()).collect(Collectors.joining(" ", "/", ""));
        cmd = (String)cmd + " " + this.getUsage().get();
        return cmd;
    }

    @ParametersAreNonnullByDefault
    protected void sendHelp(CommandSender sender, String label) {
        if (this.hasSubCommands()) {
            for (SubCommand subCommand : this.getSubCommands()) {
                subCommand.sendHelp(sender, label);
            }
        } else {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + this.getFullUsage(label) + String.valueOf(ChatColor.WHITE) + " - " + this.getDescription().apply(this, sender));
        }
    }

    @ParametersAreNonnullByDefault
    public abstract void onExecute(CommandSender var1, String[] var2);

    @ParametersAreNonnullByDefault
    public List<String> onTab(CommandSender sender, String[] args) {
        return List.of();
    }

    @Generated
    public Set<SubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Generated
    public AbstractCommand getParent() {
        return this.parent;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public BiFunction<AbstractCommand, CommandSender, String> getDescription() {
        return this.description;
    }

    @Generated
    public Usage getUsage() {
        return this.usage;
    }
}

