/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.items.common;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.genetics.DNA;
import net.guizhanss.gcereborn.items.GCEItems;
import net.guizhanss.gcereborn.utils.ChickenUtils;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

public class ResourceEgg
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable {
    private final Material resource;
    private final boolean allowInNether;

    public ResourceEgg(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, Material resource, boolean allowInNether) {
        super(itemGroup, item, recipeType, ResourceEgg.makeRecipe(resource));
        this.resource = resource;
        this.allowInNether = allowInNether;
    }

    @Nonnull
    private static ItemStack[] makeRecipe(@Nonnull Material resource) {
        ItemStack[] recipe = new ItemStack[9];
        ItemStack fake = GCEItems.POCKET_CHICKEN.item();
        DNA dna = resource == Material.WATER ? new DNA(62) : new DNA(41);
        ChickenUtils.setPocketChicken(fake, null, dna);
        recipe[4] = fake;
        return recipe;
    }

    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            Optional block = e.getClickedBlock();
            if (block.isEmpty()) {
                return;
            }
            Block b = (Block)block.get();
            Block place = b.getRelative(e.getClickedFace());
            if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), place.getLocation(), Interaction.PLACE_BLOCK)) {
                GeneticChickengineering.getLocalization().sendMessage((CommandSender)e.getPlayer(), "no-permission", new Object[0]);
                return;
            }
            if (place.isReplaceable()) {
                if (this.resource == Material.WATER && !this.allowInNether && place.getWorld().getEnvironment() == World.Environment.NETHER) {
                    place.getWorld().spawnParticle(Particle.CLOUD, place.getLocation().add(0.5, 0.0, 0.5), 5);
                    place.getWorld().playSound(place.getLocation().toCenterLocation(), Sound.BLOCK_LAVA_EXTINGUISH, 1.0f, 1.0f);
                } else {
                    place.setType(this.resource);
                }
                if (e.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    ItemUtils.consumeItem((ItemStack)e.getItem(), (boolean)false);
                }
            }
        };
    }
}

