/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.core.services;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.libs.guizhanlib.minecraft.utils.ChatUtil;
import net.guizhanss.gcereborn.libs.guizhanlib.slimefun.addon.SlimefunLocalization;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class LocalizationService
extends SlimefunLocalization {
    public LocalizationService(GeneticChickengineering plugin) {
        super(plugin);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public String getString(String key, Object ... args) {
        return MessageFormat.format(this.getString(key), args);
    }

    @ParametersAreNonnullByDefault
    public void sendMessage(CommandSender sender, String messageKey, Object ... args) {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"CommandSender cannot be null");
        Preconditions.checkArgument((messageKey != null ? 1 : 0) != 0, (Object)"Message key cannot be null");
        ChatUtil.send(sender, MessageFormat.format(this.getString("messages." + messageKey), args), new Object[0]);
    }

    @ParametersAreNonnullByDefault
    public void sendActionbarMessage(Player p, String messageKey, Object ... args) {
        Preconditions.checkArgument((p != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        Preconditions.checkArgument((messageKey != null ? 1 : 0) != 0, (Object)"Message key cannot be null");
        String message = MessageFormat.format(this.getString("messages." + messageKey), args);
        BaseComponent[] components = TextComponent.fromLegacyText((String)ChatUtil.color(message));
        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
    }
}

