/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.core.services;

import com.bgsoftware.wildstacker.api.WildStackerAPI;
import com.bgsoftware.wildstacker.api.objects.StackedEntity;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.integrations.wildstacker.EntityStackListener;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.LivingEntity;
import uk.antiperson.stackmob.StackMob;
import uk.antiperson.stackmob.entity.StackEntity;

public final class IntegrationService {
    private final GeneticChickengineering plugin;
    private final boolean stackMobEnabled;
    private final boolean wildStackerEnabled;
    private StackMob stackMobInst;

    public IntegrationService(GeneticChickengineering plugin) {
        this.plugin = plugin;
        this.stackMobEnabled = this.isEnabled("StackMob");
        this.wildStackerEnabled = this.isEnabled("WildStacker");
        if (this.stackMobEnabled) {
            this.stackMobInst = (StackMob)plugin.getServer().getPluginManager().getPlugin("StackMob");
        }
        if (this.wildStackerEnabled) {
            new EntityStackListener(plugin);
        }
    }

    private boolean isEnabled(@Nonnull String pluginName) {
        boolean result = this.plugin.getServer().getPluginManager().isPluginEnabled(pluginName);
        if (result) {
            GeneticChickengineering.log(Level.INFO, GeneticChickengineering.getLocalization().getString("console.load.integration", pluginName), new Object[0]);
        }
        return result;
    }

    public void captureChicken(@Nonnull Chicken chicken) {
        try {
            if (this.stackMobEnabled) {
                StackEntity stackEntity = this.stackMobInst.getEntityManager().getStackEntity((LivingEntity)chicken);
                if (stackEntity != null && stackEntity.getSize() > 1) {
                    stackEntity.incrementSize(-1);
                } else {
                    chicken.remove();
                }
            } else if (this.wildStackerEnabled) {
                StackedEntity stackedEntity = WildStackerAPI.getStackedEntity((LivingEntity)chicken);
                if (stackedEntity != null && stackedEntity.getStackAmount() > 1) {
                    stackedEntity.decreaseStackAmount(1, true);
                } else {
                    chicken.remove();
                }
            } else {
                chicken.remove();
            }
        }
        catch (Exception e) {
            GeneticChickengineering.log(Level.SEVERE, e, "An error has occurred while capturing chicken", new Object[0]);
            chicken.remove();
        }
    }

    public GeneticChickengineering getPlugin() {
        return this.plugin;
    }

    public boolean isStackMobEnabled() {
        return this.stackMobEnabled;
    }

    public boolean isWildStackerEnabled() {
        return this.wildStackerEnabled;
    }

    public StackMob getStackMobInst() {
        return this.stackMobInst;
    }
}

