/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.core.services;

import javax.annotation.Nonnull;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.libs.guizhanlib.slimefun.addon.AddonConfig;

public final class ConfigurationService {
    private final AddonConfig config;
    private boolean autoUpdate;
    private boolean debug;
    private boolean test;
    private String lang;
    private boolean displayResources;
    private int maxMutation;
    private int mutationRate;
    private int resourceFailRate;
    private int resourceBaseTime;
    private boolean painEnabled;
    private double painChance;
    private boolean painDeathEnabled;
    private int healRate;
    private boolean netherWaterEnabled;
    private boolean commandsEnabled;

    public ConfigurationService(GeneticChickengineering plugin) {
        this.config = new AddonConfig(plugin, "config.yml");
        this.reload();
    }

    public void reload() {
        this.config.reload();
        this.autoUpdate = this.config.getBoolean("options.auto-update", true);
        this.debug = this.config.getBoolean("options.debug", false);
        this.test = this.config.getBoolean("options.test", false);
        this.lang = this.config.getString("options.lang", "en-US");
        this.displayResources = this.config.getBoolean("options.display-resource-in-name", true);
        this.maxMutation = this.config.getInt("options.max-mutation", 1, 2, 6);
        this.mutationRate = this.config.getInt("options.mutation-rate", 1, 30, 100);
        this.resourceFailRate = this.config.getInt("options.resource-fail-rate", 0, 0, 100);
        this.resourceBaseTime = this.config.getInt("options.resource-base-time", 14, 14, 100);
        this.painEnabled = this.config.getBoolean("options.enable-pain", false);
        this.painChance = this.config.getDouble("options.pain-chance", 0.0, 2.0, 100.0);
        this.painDeathEnabled = this.config.getBoolean("options.pain-kills", false);
        this.healRate = this.config.getInt("options.heal-rate", 1, 2, 120);
        this.netherWaterEnabled = this.config.getBoolean("options.allow-nether-water", false);
        this.commandsEnabled = this.config.getBoolean("commands.enabled", true);
        this.config.save();
    }

    public boolean isSubCommandEnabled(@Nonnull String subCommand) {
        return this.config.getBoolean("commands.subcommands." + subCommand + ".enabled", true);
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isTest() {
        return this.test;
    }

    public String getLang() {
        return this.lang;
    }

    public boolean isDisplayResources() {
        return this.displayResources;
    }

    public int getMaxMutation() {
        return this.maxMutation;
    }

    public int getMutationRate() {
        return this.mutationRate;
    }

    public int getResourceFailRate() {
        return this.resourceFailRate;
    }

    public int getResourceBaseTime() {
        return this.resourceBaseTime;
    }

    public boolean isPainEnabled() {
        return this.painEnabled;
    }

    public double getPainChance() {
        return this.painChance;
    }

    public boolean isPainDeathEnabled() {
        return this.painDeathEnabled;
    }

    public int getHealRate() {
        return this.healRate;
    }

    public boolean isNetherWaterEnabled() {
        return this.netherWaterEnabled;
    }

    public boolean isCommandsEnabled() {
        return this.commandsEnabled;
    }
}

