/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.core.commands;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.gcereborn.GeneticChickengineering;
import org.bukkit.command.CommandSender;

public abstract class SubCommand {
    private final String name;
    private final boolean isHidden;
    private final String permission;
    private final String usage;

    protected SubCommand(@Nonnull String name, boolean hidden, @Nullable String permission, @Nonnull String usage) {
        this.name = name;
        this.isHidden = hidden;
        this.permission = permission;
        this.usage = usage;
    }

    public boolean isSubCommand(@Nonnull String cmd) {
        return this.name.equalsIgnoreCase(cmd);
    }

    @Nonnull
    public String getDescription() {
        return GeneticChickengineering.getLocalization().getString("commands." + this.name + ".description");
    }

    @ParametersAreNonnullByDefault
    public abstract void onCommand(CommandSender var1, String[] var2);

    @ParametersAreNonnullByDefault
    protected boolean canExecute(CommandSender sender, String[] args) {
        if (this.permission != null && !sender.hasPermission(this.permission)) {
            GeneticChickengineering.getLocalization().sendMessage(sender, "no-permission", new Object[0]);
            return false;
        }
        String[] usageArgs = this.usage.split(" ");
        int argsLength = 1;
        for (String usageArg : usageArgs) {
            if (usageArg.startsWith("[")) break;
            ++argsLength;
        }
        if (args.length != argsLength) {
            GeneticChickengineering.getLocalization().sendMessage(sender, "usage", "/gce " + this.getName() + " " + this.usage);
            return false;
        }
        return true;
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return List.of();
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getUsage() {
        return this.usage;
    }
}

