/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.items.chicken;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.gcereborn.GeneticChickengineering;
import org.bukkit.inventory.ItemStack;

public class ChickenProduct {
    private final String name;
    private final ItemStack product;

    @ParametersAreNonnullByDefault
    public ChickenProduct(String name, ItemStack product) {
        this.name = name.toUpperCase(Locale.ROOT);
        this.product = product;
    }

    @ParametersAreNonnullByDefault
    public ChickenProduct(ItemStack product) {
        ItemStack itemStack = product;
        if (itemStack instanceof SlimefunItemStack) {
            SlimefunItemStack sfProduct = (SlimefunItemStack)itemStack;
            this.name = sfProduct.getItemId();
        } else {
            this.name = product.getType().name().toUpperCase(Locale.ROOT);
        }
        this.product = product;
    }

    @Nonnull
    public String getProductName() {
        return GeneticChickengineering.getLocalization().getString("products." + this.name);
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getProduct() {
        return this.product;
    }
}

