/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.integrations.wildstacker;

import com.bgsoftware.wildstacker.api.events.EntityStackEvent;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.services.DatabaseService;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class EntityStackListener
implements Listener {
    public EntityStackListener(GeneticChickengineering plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onEntityStack(EntityStackEvent e) {
        if (e.getEntity().getType() != EntityType.CHICKEN || e.getTarget().getType() != EntityType.CHICKEN) {
            return;
        }
        Chicken source = (Chicken)e.getEntity().getLivingEntity();
        Chicken target = (Chicken)e.getTarget().getLivingEntity();
        DatabaseService dbService = GeneticChickengineering.getDatabaseService();
        GeneticChickengineering.debug("source: " + source.getUniqueId() + ", has dna: " + dbService.hasChicken(source.getUniqueId()), new Object[0]);
        GeneticChickengineering.debug("target: " + target.getUniqueId() + ", has dna: " + dbService.hasChicken(target.getUniqueId()), new Object[0]);
        if (!dbService.hasChicken(source.getUniqueId()) && !dbService.hasChicken(target.getUniqueId())) {
            return;
        }
        if (dbService.hasChicken(source.getUniqueId()) != dbService.hasChicken(target.getUniqueId())) {
            e.setCancelled(true);
            return;
        }
        if (!dbService.getChickenDNA(source.getUniqueId()).equals(dbService.getChickenDNA(target.getUniqueId()))) {
            e.setCancelled(true);
        }
    }
}

