/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.items.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.services.ConfigurationService;
import net.guizhanss.gcereborn.items.GCEItems;
import net.guizhanss.gcereborn.items.machines.AbstractMachine;
import net.guizhanss.gcereborn.utils.PocketChickenUtils;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class RestorationChamber
extends AbstractMachine {
    public RestorationChamber(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    public ItemStack getProgressBar() {
        return GCEItems.POCKET_CHICKEN.clone();
    }

    @Nullable
    protected MachineRecipe findNextRecipe(@Nonnull BlockMenu menu) {
        ConfigurationService config = GeneticChickengineering.getConfigService();
        ItemStack chicken = null;
        ItemStack seed = null;
        for (int slot : this.getInputSlots()) {
            ItemStack item = menu.getItemInSlot(slot);
            if (item == null || item.getType() == Material.AIR) continue;
            if (PocketChickenUtils.isPocketChicken(item)) {
                chicken = item;
                continue;
            }
            if (item.getType() != Material.WHEAT_SEEDS) continue;
            seed = item;
        }
        if (chicken == null || seed == null) {
            return null;
        }
        double health = PocketChickenUtils.getHealth(chicken);
        int seedAmount = seed.getAmount();
        int toConsume = 0;
        while (seedAmount > 0 && health < 4.0) {
            --seedAmount;
            ++toConsume;
            health += 0.25;
        }
        if (toConsume == 0) {
            return null;
        }
        ItemStack recipeSeeds = seed.clone();
        recipeSeeds.setAmount(toConsume);
        ItemStack recipeChick = chicken.clone();
        PocketChickenUtils.heal(recipeChick, (double)toConsume * 0.25);
        int healRate = GeneticChickengineering.getConfigService().getHealRate();
        MachineRecipe recipe = new MachineRecipe(config.isTest() ? 1 : healRate * toConsume, new ItemStack[]{recipeSeeds, chicken.clone()}, new ItemStack[]{recipeChick});
        if (!InvUtils.fitAll((Inventory)menu.toInventory(), (ItemStack[])recipe.getOutput(), (int[])this.getOutputSlots())) {
            return null;
        }
        ItemUtils.consumeItem((ItemStack)chicken, (boolean)false);
        ItemUtils.consumeItem((ItemStack)seed, (int)toConsume, (boolean)false);
        return recipe;
    }
}

