/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.core.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.services.LocalizationService;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public interface MobAdapter<T extends LivingEntity>
extends PersistentDataType<String, JsonObject> {
    public Class<T> getEntityClass();

    default public List<String> getLore(JsonObject json) {
        int fireTicks;
        LinkedList<String> lore = new LinkedList<String>();
        LocalizationService localization = GeneticChickengineering.getLocalization();
        lore.add("");
        lore.add(localization.getString("lores.chicken.health", json.get("_health").getAsDouble()));
        if (!json.get("_customName").isJsonNull()) {
            lore.add(localization.getString("lores.chicken.name", json.get("_customName").getAsString()));
        }
        if ((fireTicks = json.get("_fireTicks").getAsInt()) > 0) {
            lore.add(localization.getString("lores.chicken.on-fire"));
        }
        return lore;
    }

    default public Class<String> getPrimitiveType() {
        return String.class;
    }

    default public Class<JsonObject> getComplexType() {
        return JsonObject.class;
    }

    default public String toPrimitive(JsonObject json, PersistentDataAdapterContext context) {
        return json.toString();
    }

    default public JsonObject fromPrimitive(String primitive, PersistentDataAdapterContext context) {
        return new JsonParser().parse(primitive).getAsJsonObject();
    }

    default public void apply(T entity, JsonObject json) {
        JsonObject attributes = json.getAsJsonObject("_attributes");
        for (Object entry : attributes.entrySet()) {
            AttributeInstance instance = entity.getAttribute(Attribute.valueOf((String)((String)entry.getKey())));
            if (instance == null) continue;
            for (AttributeModifier modifier : new ArrayList(instance.getModifiers())) {
                instance.removeModifier(modifier);
            }
            JsonObject attribute = ((JsonElement)entry.getValue()).getAsJsonObject();
            instance.setBaseValue(attribute.get("base").getAsDouble());
            JsonArray modifiers = attribute.getAsJsonArray("modifiers");
            for (JsonElement modifier : modifiers) {
                JsonObject obj = modifier.getAsJsonObject();
                String uuid = obj.get("uuid").getAsString();
                String name = obj.get("name").getAsString();
                double amount = obj.get("amount").getAsDouble();
                int operation = obj.get("operation").getAsInt();
                AttributeModifier mod = new AttributeModifier(UUID.fromString(uuid), name, amount, AttributeModifier.Operation.values()[operation]);
                instance.addModifier(mod);
            }
        }
        entity.setHealth(json.get("_health").getAsDouble());
        entity.setAbsorptionAmount(json.get("_absorption").getAsDouble());
        entity.setRemoveWhenFarAway(json.get("_removeWhenFarAway").getAsBoolean());
        if (!json.get("_customName").isJsonNull()) {
            entity.setCustomName(json.get("_customName").getAsString());
        }
        entity.setCustomNameVisible(json.get("_customNameVisible").getAsBoolean());
        entity.setAI(json.get("_ai").getAsBoolean());
        entity.setSilent(json.get("_silent").getAsBoolean());
        entity.setGlowing(json.get("_glowing").getAsBoolean());
        entity.setInvulnerable(json.get("_invulnerable").getAsBoolean());
        entity.setCollidable(json.get("_collidable").getAsBoolean());
        entity.setGravity(json.get("_gravity").getAsBoolean());
        entity.setFireTicks(json.get("_fireTicks").getAsInt());
        JsonObject effects = json.getAsJsonObject("_effects");
        for (Map.Entry entry : effects.entrySet()) {
            PotionEffectType type = PotionEffectType.getByName((String)((String)entry.getKey()));
            if (type == null) continue;
            JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
            int duration = obj.get("duration").getAsInt();
            int amplifier = obj.get("amplifier").getAsInt();
            boolean ambient = obj.get("ambient").getAsBoolean();
            boolean particles = obj.get("particles").getAsBoolean();
            boolean icon = obj.get("icon").getAsBoolean();
            entity.addPotionEffect(new PotionEffect(type, duration, amplifier, ambient, particles, icon));
        }
        JsonArray tags = json.getAsJsonArray("_scoreboardTags");
        for (JsonElement tag : tags) {
            entity.addScoreboardTag(tag.getAsString());
        }
    }

    default public JsonObject saveData(T entity) {
        JsonObject json = new JsonObject();
        json.addProperty("_type", entity.getType().toString());
        json.addProperty("_health", (Number)entity.getHealth());
        json.addProperty("_absorption", (Number)entity.getAbsorptionAmount());
        json.addProperty("_removeWhenFarAway", Boolean.valueOf(entity.getRemoveWhenFarAway()));
        json.addProperty("_customName", entity.getCustomName());
        json.addProperty("_customNameVisible", Boolean.valueOf(entity.isCustomNameVisible()));
        json.addProperty("_ai", Boolean.valueOf(entity.hasAI()));
        json.addProperty("_silent", Boolean.valueOf(entity.isSilent()));
        json.addProperty("_glowing", Boolean.valueOf(entity.isGlowing()));
        json.addProperty("_invulnerable", Boolean.valueOf(entity.isInvulnerable()));
        json.addProperty("_collidable", Boolean.valueOf(entity.isCollidable()));
        json.addProperty("_gravity", Boolean.valueOf(entity.hasGravity()));
        json.addProperty("_fireTicks", (Number)entity.getFireTicks());
        JsonObject attributes = new JsonObject();
        for (Attribute attribute : Attribute.values()) {
            AttributeInstance instance = entity.getAttribute(attribute);
            if (instance == null) continue;
            JsonObject obj = new JsonObject();
            obj.addProperty("base", (Number)instance.getBaseValue());
            JsonArray modifiers = new JsonArray();
            for (AttributeModifier modifier : instance.getModifiers()) {
                JsonObject mod = new JsonObject();
                mod.addProperty("uuid", modifier.getUniqueId().toString());
                mod.addProperty("name", modifier.getName());
                mod.addProperty("operation", (Number)modifier.getOperation().ordinal());
                mod.addProperty("amount", (Number)modifier.getAmount());
                modifiers.add((JsonElement)mod);
            }
            obj.add("modifiers", (JsonElement)modifiers);
            attributes.add(attribute.toString(), (JsonElement)obj);
        }
        json.add("_attributes", (JsonElement)attributes);
        JsonObject effects = new JsonObject();
        for (PotionEffect effect : entity.getActivePotionEffects()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("duration", (Number)effect.getDuration());
            obj.addProperty("amplifier", (Number)effect.getAmplifier());
            obj.addProperty("ambient", Boolean.valueOf(effect.isAmbient()));
            obj.addProperty("particles", Boolean.valueOf(effect.hasParticles()));
            obj.addProperty("icon", Boolean.valueOf(effect.hasIcon()));
            effects.add(effect.getType().getName(), (JsonElement)obj);
        }
        json.add("_effects", (JsonElement)effects);
        JsonArray tags = new JsonArray();
        for (String tag : entity.getScoreboardTags()) {
            tags.add(tag);
        }
        json.add("_scoreboardTags", (JsonElement)tags);
        return json;
    }
}

