/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import net.guizhanss.gcereborn.core.commands.GCECommand;
import net.guizhanss.gcereborn.core.commands.GCECompleter;
import net.guizhanss.gcereborn.core.services.ConfigurationService;
import net.guizhanss.gcereborn.core.services.DatabaseService;
import net.guizhanss.gcereborn.core.services.IntegrationService;
import net.guizhanss.gcereborn.core.services.LocalizationService;
import net.guizhanss.gcereborn.libs.bstats.bukkit.Metrics;
import net.guizhanss.gcereborn.libs.guizhanlib.slimefun.addon.AbstractAddon;
import net.guizhanss.gcereborn.libs.guizhanlib.updater.GuizhanBuildsUpdater;
import net.guizhanss.gcereborn.listeners.WorldSavedListener;
import net.guizhanss.gcereborn.setup.Items;
import net.guizhanss.gcereborn.setup.Researches;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class GeneticChickengineering
extends AbstractAddon {
    private static final String DEFAULT_LANG = "en-US";
    private ConfigurationService configService;
    private LocalizationService localization;
    private DatabaseService dbService;
    private IntegrationService integrationService;
    private boolean debugEnabled = false;

    public GeneticChickengineering() {
        super("ybw0014", "GeneticChickengineering-Reborn", "master", "options.auto-update");
    }

    @Nonnull
    public static ConfigurationService getConfigService() {
        return GeneticChickengineering.inst().configService;
    }

    @Nonnull
    public static LocalizationService getLocalization() {
        return GeneticChickengineering.inst().localization;
    }

    @Nonnull
    public static DatabaseService getDatabaseService() {
        return GeneticChickengineering.inst().dbService;
    }

    @Nonnull
    public static IntegrationService getIntegrationService() {
        return GeneticChickengineering.inst().integrationService;
    }

    public static void debug(@Nonnull String message, Object ... args) {
        Preconditions.checkNotNull((Object)message, (Object)"message cannot be null");
        if (GeneticChickengineering.inst().debugEnabled) {
            GeneticChickengineering.inst().getLogger().log(Level.INFO, "[DEBUG] " + message, args);
        }
    }

    @Nonnull
    private static GeneticChickengineering inst() {
        return (GeneticChickengineering)((Object)GeneticChickengineering.getInstance());
    }

    @Override
    public void enable() {
        File datadir = this.getDataFolder();
        if (!datadir.exists()) {
            datadir.mkdirs();
        }
        this.configService = new ConfigurationService(this);
        this.debugEnabled = this.configService.isDebug();
        GeneticChickengineering.log(Level.INFO, "Loading language...", new Object[0]);
        String lang = this.configService.getLang();
        this.localization = new LocalizationService(this);
        this.localization.addLanguage(lang);
        if (!lang.equals(DEFAULT_LANG)) {
            this.localization.addLanguage(DEFAULT_LANG);
        }
        this.localization.setIdPrefix("GCE_");
        GeneticChickengineering.log(Level.INFO, this.localization.getString("console.load.language"), lang);
        if (!PaperLib.isPaper()) {
            GeneticChickengineering.log(Level.SEVERE, this.localization.getString("console.paper-only"), new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        GeneticChickengineering.log(Level.INFO, this.localization.getString("console.load.database"), new Object[0]);
        this.dbService = new DatabaseService(this);
        if (!this.dbService.isConnected()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        GeneticChickengineering.log(Level.INFO, this.localization.getString("console.load.items"), new Object[0]);
        Items.setup(this);
        GeneticChickengineering.log(Level.INFO, this.localization.getString("console.load.researches"), new Object[0]);
        Researches.setup();
        new WorldSavedListener(this);
        if (this.configService.isCommandsEnabled()) {
            PluginCommand command = this.getCommand("geneticchickengineering");
            if (command == null) {
                GeneticChickengineering.log(Level.SEVERE, this.localization.getString("console.load.commands-fail"), new Object[0]);
            } else {
                GCECommand gceCommand = new GCECommand();
                command.setExecutor((CommandExecutor)gceCommand);
                command.setTabCompleter((TabCompleter)new GCECompleter(gceCommand));
            }
        }
        GeneticChickengineering.log(Level.INFO, this.localization.getString("console.load.integrations"), new Object[0]);
        this.integrationService = new IntegrationService(this);
        this.setupMetrics();
    }

    @Override
    public void disable() {
        if (this.dbService != null) {
            this.dbService.cleanup();
            this.dbService.shutdown();
        }
    }

    private void setupMetrics() {
        new Metrics(this, 20243);
    }

    @Override
    protected void autoUpdate() {
        if (this.getPluginVersion().startsWith("DEV")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), this.getGithubRepo()).start();
        } else if (this.getPluginVersion().startsWith("Build")) {
            try {
                Class<?> clazz = Class.forName("net.guizhanss.gcereborn.libs.guizhanlibplugin.updater.GuizhanUpdater");
                Method updaterStart = clazz.getDeclaredMethod("start", Plugin.class, File.class, String.class, String.class, String.class);
                updaterStart.invoke(null, new Object[]{this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()});
            }
            catch (Exception ignored) {
                new GuizhanBuildsUpdater((Plugin)this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()).start();
            }
        }
    }
}

