/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.core.commands;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.commands.SubCommand;
import net.guizhanss.gcereborn.core.commands.subcommands.CalcChanceCommand;
import net.guizhanss.gcereborn.core.commands.subcommands.MakeChickenCommand;
import net.guizhanss.gcereborn.core.services.ConfigurationService;
import net.guizhanss.gcereborn.libs.guizhanlib.minecraft.utils.ChatUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public final class GCECommand
implements CommandExecutor {
    private final Set<SubCommand> subCommands = new HashSet<SubCommand>();

    public GCECommand() {
        ConfigurationService config = GeneticChickengineering.getConfigService();
        if (config.isSubCommandEnabled("makechicken")) {
            this.subCommands.add(new MakeChickenCommand());
        }
        if (config.isSubCommandEnabled("calcchance")) {
            this.subCommands.add(new CalcChanceCommand());
        }
    }

    @ParametersAreNonnullByDefault
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0) {
            for (SubCommand subCommand : this.subCommands) {
                if (!subCommand.isSubCommand(args[0])) continue;
                subCommand.onCommand(sender, args);
                return true;
            }
            this.sendHelp(sender);
        } else {
            this.sendHelp(sender);
        }
        return true;
    }

    public void sendHelp(@Nonnull CommandSender sender) {
        sender.sendMessage(ChatUtil.color("&e&lGeneticChickengineering &6v" + GeneticChickengineering.getInstance().getPluginVersion()));
        for (SubCommand subCommand : this.subCommands) {
            if (subCommand.isHidden()) continue;
            sender.sendMessage(ChatUtil.color("&e/gce " + subCommand.getName() + "&7 - " + subCommand.getDescription()));
        }
    }

    public Set<SubCommand> getSubCommands() {
        return this.subCommands;
    }
}

