/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.items.chicken;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.adapters.AnimalsAdapter;
import net.guizhanss.gcereborn.core.genetics.DNA;
import net.guizhanss.gcereborn.items.chicken.ChickenTypes;
import net.guizhanss.gcereborn.utils.Keys;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Chicken;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataHolder;

public class PocketChicken
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable {
    public static final AnimalsAdapter<Chicken> ADAPTER = new AnimalsAdapter<Chicken>(Chicken.class);

    public PocketChicken(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            Optional block = e.getClickedBlock();
            if (block.isEmpty()) {
                return;
            }
            Block b = (Block)block.get();
            Location location = b.getRelative(e.getClickedFace()).getLocation();
            Chicken entity = (Chicken)b.getWorld().spawn(location.toCenterLocation(), Chicken.class);
            ItemMeta meta = e.getItem().getItemMeta();
            JsonObject json = (JsonObject)PersistentDataAPI.get((PersistentDataHolder)meta, (NamespacedKey)Keys.ADAPTER, ADAPTER);
            ADAPTER.apply(entity, json);
            int[] dnaState = PersistentDataAPI.getIntArray((PersistentDataHolder)meta, (NamespacedKey)Keys.DNA);
            DNA dna = dnaState != null ? new DNA(dnaState) : new DNA();
            String dss = dna.getStateString();
            entity.setMetadata("gce_pocket_chicken_dna", (MetadataValue)new FixedMetadataValue(GeneticChickengineering.getInstance(), (Object)dss));
            GeneticChickengineering.getDatabaseService().addChicken(entity.getUniqueId().toString(), dss);
            if (e.getPlayer().getGameMode() != GameMode.CREATIVE) {
                ItemUtils.consumeItem((ItemStack)e.getItem(), (boolean)false);
            }
            if (GeneticChickengineering.getConfigService().isDisplayResources() && dna.isKnown()) {
                String name = "(" + ChickenTypes.getDisplayName(dna.getTyping()) + ")";
                if (json != null) {
                    if (!json.get("_customName").isJsonNull()) {
                        name = json.get("_customName").getAsString() + " " + name;
                    }
                    json.addProperty("_customNameVisible", Boolean.valueOf(true));
                    json.addProperty("_customName", name);
                    ADAPTER.apply(entity, json);
                } else {
                    entity.setCustomName(name);
                    entity.setCustomNameVisible(true);
                }
            }
        };
    }
}

