/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.core.genetics;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.genetics.Gene;
import net.guizhanss.gcereborn.core.services.ConfigurationService;

public class DNA {
    private static final char[] ALLELES = new char[]{'b', 'c', 'd', 'f', 's', 'w'};
    private static final boolean[] BOOL_CAST = new boolean[]{false, true};
    private final Gene[] sequence;
    private boolean learned;

    public DNA(int[] state) {
        this.sequence = new Gene[6];
        for (int i = 0; i < 6; ++i) {
            this.sequence[i] = new Gene(ALLELES[i], state[i]);
        }
        this.learned = BOOL_CAST[state[6]];
    }

    public DNA(@Nonnull String state) {
        char[] stateChars = state.toCharArray();
        this.sequence = new Gene[6];
        for (int i = 0; i < 6; ++i) {
            this.sequence[i] = new Gene(ALLELES[i], Character.getNumericValue(stateChars[i]));
        }
        this.learned = BOOL_CAST[Character.getNumericValue(stateChars[6])];
    }

    public DNA(int typing) {
        this.sequence = new Gene[6];
        String typeStr = Integer.toBinaryString(typing);
        String padded = String.format("%6s", typeStr).replaceAll(" ", "0");
        for (int i = 0; i < 6; ++i) {
            this.sequence[i] = new Gene(ALLELES[i], 3 * (padded.charAt(i) - 48));
        }
        this.learned = true;
    }

    public DNA(char[] half1, char[] half2) {
        this.sequence = new Gene[6];
        for (int i = 0; i < 6; ++i) {
            this.sequence[i] = new Gene(new char[]{half1[i], half2[i]});
        }
        this.learned = false;
    }

    public DNA(char[] notation) {
        this.sequence = new Gene[6];
        for (int i = 0; i < 6; ++i) {
            this.sequence[i] = new Gene(new char[]{notation[2 * i], notation[2 * i + 1]});
        }
        this.learned = true;
    }

    public DNA() {
        ConfigurationService config = GeneticChickengineering.getConfigService();
        this.sequence = new Gene[6];
        int[] mutations = new Random().ints(0, 6).distinct().limit(config.getMaxMutation()).toArray();
        for (int i = 0; i < 6; ++i) {
            char notation = Character.toUpperCase(ALLELES[i]);
            char[] markup = new char[]{notation, notation};
            int z = i;
            boolean isMutated = Arrays.stream(mutations).anyMatch(x -> x == z);
            if (isMutated && ThreadLocalRandom.current().nextInt(100) < config.getMutationRate()) {
                markup[1] = ALLELES[i];
            }
            this.sequence[i] = new Gene(markup);
        }
        this.learned = false;
    }

    public static boolean isValidSequence(String seq) {
        return DNA.isValidSequence(seq.toCharArray());
    }

    public static boolean isValidSequence(char[] seq) {
        if (seq.length != 12) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            char allele = ALLELES[i];
            if (Character.toLowerCase(seq[2 * i]) == allele && Character.toLowerCase(seq[2 * i + 1]) == allele) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public String toString() {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            out.append(this.sequence[i].toString());
        }
        return out.toString();
    }

    public char[] split() {
        char[] out = new char[6];
        for (int i = 0; i < 6; ++i) {
            out[i] = this.sequence[i].split();
        }
        return out;
    }

    public Gene[] getGenes() {
        return this.sequence;
    }

    public Gene getGene(int index) {
        return this.sequence[index];
    }

    public int[] getState() {
        int[] out = new int[7];
        for (int i = 0; i < 6; ++i) {
            out[i] = this.sequence[i].getState();
        }
        out[6] = this.learned ? 1 : 0;
        return out;
    }

    public String getStateString() {
        char[] out = new char[7];
        int[] state = this.getState();
        for (int i = 0; i < 7; ++i) {
            out[i] = (char)(state[i] + 48);
        }
        return new String(out);
    }

    public int getTyping() {
        int out = 0;
        for (int i = 5; i > -1; --i) {
            if (!this.sequence[i].isDominant()) continue;
            out += (int)Math.pow(2.0, 5 - i);
        }
        return out;
    }

    public int getTier() {
        int out = 0;
        for (int i = 5; i > -1; --i) {
            if (this.sequence[i].isDominant()) continue;
            ++out;
        }
        return out;
    }

    public boolean isKnown() {
        return this.learned;
    }

    public void learn() {
        this.learned = true;
    }

    public static char[] ALLELES() {
        return ALLELES;
    }
}

