/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.libs.guizhanlib.slimefun.utils;

import com.xzavier0722.mc.plugin.slimefun4.storage.controller.SlimefunBlockData;
import com.xzavier0722.mc.plugin.slimefun4.storage.util.StorageCacheUtils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.block.Block;

public final class NewBlockStorageUtil {
    @Nonnull
    @ParametersAreNonnullByDefault
    public static SlimefunBlockData createBlock(Location l, String sfId) {
        return Slimefun.getDatabaseManager().getBlockDataController().createBlock(l, sfId);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static SlimefunBlockData createBlock(Block b, String sfId) {
        return NewBlockStorageUtil.createBlock(b.getLocation(), sfId);
    }

    public static void removeBlock(@Nonnull Location l) {
        Slimefun.getDatabaseManager().getBlockDataController().removeBlock(l);
    }

    public static void removeBlock(@Nonnull Block b) {
        NewBlockStorageUtil.removeBlock(b.getLocation());
    }

    public static boolean hasBlock(@Nonnull Location l) {
        return StorageCacheUtils.hasBlock((Location)l);
    }

    public static boolean hasBlock(@Nonnull Block b) {
        return NewBlockStorageUtil.hasBlock(b.getLocation());
    }

    @Nullable
    public static SlimefunBlockData getBlock(@Nonnull Location l) {
        return StorageCacheUtils.getBlock((Location)l);
    }

    @Nullable
    public static SlimefunBlockData getBlock(@Nonnull Block b) {
        return NewBlockStorageUtil.getBlock(b.getLocation());
    }

    @ParametersAreNonnullByDefault
    public static boolean isBlock(Location l, String sfId) {
        return StorageCacheUtils.isBlock((Location)l, (String)sfId);
    }

    @ParametersAreNonnullByDefault
    public static boolean isBlock(Block b, String sfId) {
        return NewBlockStorageUtil.isBlock(b.getLocation(), sfId);
    }

    @ParametersAreNonnullByDefault
    public static boolean isBlock(Location l, SlimefunItem sfItem) {
        SlimefunBlockData data = NewBlockStorageUtil.getBlock(l);
        return data != null && data.getSfId().equals(sfItem.getId());
    }

    @ParametersAreNonnullByDefault
    public static boolean isBlock(Block b, SlimefunItem sfItem) {
        return NewBlockStorageUtil.isBlock(b.getLocation(), sfItem);
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public static String getData(Location l, String key) {
        return StorageCacheUtils.getData((Location)l, (String)key);
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public static String getData(Block b, String key) {
        return NewBlockStorageUtil.getData(b.getLocation(), key);
    }

    public static void setData(@Nonnull Location l, @Nonnull String key, @Nullable String value) {
        if (value != null) {
            StorageCacheUtils.setData((Location)l, (String)key, (String)value);
        } else {
            StorageCacheUtils.removeData((Location)l, (String)key);
        }
    }

    public static void setData(@Nonnull Block b, @Nonnull String key, @Nullable String value) {
        NewBlockStorageUtil.setData(b.getLocation(), key, value);
    }

    @Nullable
    public static BlockMenu getMenu(@Nonnull Location l) {
        return StorageCacheUtils.getMenu((Location)l);
    }

    @Nullable
    public static BlockMenu getMenu(@Nonnull Block b) {
        return NewBlockStorageUtil.getMenu(b.getLocation());
    }

    public static void requestLoad(@Nonnull SlimefunBlockData data) {
        StorageCacheUtils.requestLoad((SlimefunBlockData)data);
    }

    public static void requestLoad(@Nonnull Location l) {
        SlimefunBlockData data = NewBlockStorageUtil.getBlock(l);
        if (data == null) {
            return;
        }
        StorageCacheUtils.requestLoad((SlimefunBlockData)data);
    }

    public static void requestLoad(@Nonnull Block b) {
        NewBlockStorageUtil.requestLoad(b.getLocation());
    }

    @ParametersAreNonnullByDefault
    public static void executeAfterLoad(SlimefunBlockData data, Runnable runnable, boolean runOnMainThread) {
        StorageCacheUtils.executeAfterLoad((SlimefunBlockData)data, (Runnable)runnable, (boolean)runOnMainThread);
    }

    @ParametersAreNonnullByDefault
    public static void executeAfterLoad(Location l, Runnable runnable, boolean runOnMainThread) {
        SlimefunBlockData data = NewBlockStorageUtil.getBlock(l);
        if (data == null) {
            return;
        }
        NewBlockStorageUtil.executeAfterLoad(data, runnable, runOnMainThread);
    }

    @ParametersAreNonnullByDefault
    public static void executeAfterLoad(Block b, Runnable runnable, boolean runOnMainThread) {
        NewBlockStorageUtil.executeAfterLoad(b.getLocation(), runnable, runOnMainThread);
    }

    private NewBlockStorageUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

