/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.libs.guizhanlib.minecraft.utils.compatibility;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.gcereborn.libs.guizhanlib.minecraft.utils.MinecraftVersionUtil;
import org.bukkit.Particle;

public final class ParticleX {
    public static final Particle POOF;
    public static final Particle EXPLOSION;
    public static final Particle EXPLOSION_EMITTER;
    public static final Particle FIREWORK;
    public static final Particle BUBBLE;
    public static final Particle SPLASH;
    public static final Particle FISHING;
    public static final Particle UNDERWATER;
    public static final Particle ENCHANTED_HIT;
    public static final Particle SMOKE;
    public static final Particle LARGE_SMOKE;
    public static final Particle EFFECT;
    public static final Particle INSTANT_EFFECT;
    public static final Particle ENTITY_EFFECT;
    public static final Particle WITCH;
    public static final Particle DRIPPING_WATER;
    public static final Particle DRIPPING_LAVA;
    public static final Particle ANGRY_VILLAGER;
    public static final Particle HAPPY_VILLAGER;
    public static final Particle MYCELIUM;
    public static final Particle ENCHANT;
    public static final Particle DUST;
    public static final Particle ITEM_SNOWBALL;
    public static final Particle ITEM_SLIME;
    public static final Particle ITEM;
    public static final Particle BLOCK;
    public static final Particle RAIN;
    public static final Particle ELDER_GUARDIAN;
    public static final Particle TOTEM_OF_UNDYING;
    public static final Particle GUST_EMITTER_LARGE;

    @Nullable
    private static Particle getKey(@Nonnull String key) {
        try {
            Field field = Particle.class.getDeclaredField(key);
            return (Particle)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ParticleX() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        boolean isAtLeast1_20_5 = MinecraftVersionUtil.isAtLeast(20, 5);
        POOF = isAtLeast1_20_5 ? Particle.POOF : ParticleX.getKey("EXPLOSION_NORMAL");
        EXPLOSION = isAtLeast1_20_5 ? Particle.EXPLOSION : ParticleX.getKey("EXPLOSION_LARGE");
        EXPLOSION_EMITTER = isAtLeast1_20_5 ? Particle.EXPLOSION_EMITTER : ParticleX.getKey("EXPLOSION_HUGE");
        FIREWORK = isAtLeast1_20_5 ? Particle.FIREWORK : ParticleX.getKey("FIREWORKS_SPARK");
        BUBBLE = isAtLeast1_20_5 ? Particle.BUBBLE : ParticleX.getKey("WATER_BUBBLE");
        SPLASH = isAtLeast1_20_5 ? Particle.SPLASH : ParticleX.getKey("WATER_SPLASH");
        FISHING = isAtLeast1_20_5 ? Particle.FISHING : ParticleX.getKey("WATER_WAKE");
        UNDERWATER = isAtLeast1_20_5 ? Particle.UNDERWATER : ParticleX.getKey("SUSPENDED");
        ENCHANTED_HIT = isAtLeast1_20_5 ? Particle.ENCHANTED_HIT : ParticleX.getKey("CRIT_MAGIC");
        SMOKE = isAtLeast1_20_5 ? Particle.SMOKE : ParticleX.getKey("SMOKE_NORMAL");
        LARGE_SMOKE = isAtLeast1_20_5 ? Particle.LARGE_SMOKE : ParticleX.getKey("SMOKE_LARGE");
        EFFECT = isAtLeast1_20_5 ? Particle.EFFECT : ParticleX.getKey("SPELL");
        INSTANT_EFFECT = isAtLeast1_20_5 ? Particle.INSTANT_EFFECT : ParticleX.getKey("SPELL_INSTANT");
        ENTITY_EFFECT = isAtLeast1_20_5 ? Particle.ENTITY_EFFECT : ParticleX.getKey("SPELL_MOB");
        WITCH = isAtLeast1_20_5 ? Particle.WITCH : ParticleX.getKey("SPELL_WITCH");
        DRIPPING_WATER = isAtLeast1_20_5 ? Particle.DRIPPING_WATER : ParticleX.getKey("DRIP_WATER");
        DRIPPING_LAVA = isAtLeast1_20_5 ? Particle.DRIPPING_LAVA : ParticleX.getKey("DRIP_LAVA");
        ANGRY_VILLAGER = isAtLeast1_20_5 ? Particle.ANGRY_VILLAGER : ParticleX.getKey("VILLAGER_ANGRY");
        HAPPY_VILLAGER = isAtLeast1_20_5 ? Particle.HAPPY_VILLAGER : ParticleX.getKey("VILLAGER_HAPPY");
        MYCELIUM = isAtLeast1_20_5 ? Particle.MYCELIUM : ParticleX.getKey("TOWN_AURA");
        ENCHANT = isAtLeast1_20_5 ? Particle.ENCHANT : ParticleX.getKey("ENCHANTMENT_TABLE");
        DUST = isAtLeast1_20_5 ? Particle.DUST : ParticleX.getKey("REDSTONE");
        ITEM_SNOWBALL = isAtLeast1_20_5 ? Particle.ITEM_SNOWBALL : ParticleX.getKey("SNOWBALL");
        ITEM_SLIME = isAtLeast1_20_5 ? Particle.ITEM_SLIME : ParticleX.getKey("SLIME");
        ITEM = isAtLeast1_20_5 ? Particle.ITEM : ParticleX.getKey("ITEM_CRACK");
        BLOCK = isAtLeast1_20_5 ? Particle.BLOCK : ParticleX.getKey("BLOCK_DUST");
        RAIN = isAtLeast1_20_5 ? Particle.RAIN : ParticleX.getKey("WATER_DROP");
        ELDER_GUARDIAN = isAtLeast1_20_5 ? Particle.ELDER_GUARDIAN : ParticleX.getKey("MOB_APPEARANCE");
        Particle particle = TOTEM_OF_UNDYING = isAtLeast1_20_5 ? Particle.TOTEM_OF_UNDYING : ParticleX.getKey("TOTEM");
        GUST_EMITTER_LARGE = MinecraftVersionUtil.isBefore(20) ? null : (isAtLeast1_20_5 ? Particle.GUST_EMITTER_LARGE : ParticleX.getKey("GUST_EMITTER"));
    }
}

