/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.items.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.services.ConfigurationService;
import net.guizhanss.gcereborn.items.GCEItems;
import net.guizhanss.gcereborn.items.machines.AbstractMachine;
import net.guizhanss.gcereborn.utils.ChickenUtils;
import net.guizhanss.gcereborn.utils.GuiItems;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PrivateCoop
extends AbstractMachine {
    public PrivateCoop(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    public ItemStack getProgressBar() {
        return GCEItems.POCKET_CHICKEN.clone();
    }

    protected void tick(@Nonnull Block b) {
        super.tick(b);
        MachineProcessor processor = this.getMachineProcessor();
        if (processor.getOperation(b) != null) {
            BlockMenu inv;
            if (ThreadLocalRandom.current().nextDouble() < 0.25) {
                Location l = b.getLocation().toCenterLocation();
                l.getWorld().spawnParticle(Particle.HEART, l.add(0.0, 0.5, 0.0), 2, 0.2, 0.0, 0.2);
            }
            if (this.getParents(inv = BlockStorage.getInventory((Block)b)).size() != 2) {
                processor.endOperation(b);
                inv.replaceExistingItem(22, GuiItems.BLACK_PANE);
            }
        }
    }

    @Nonnull
    private List<ItemStack> getParents(@Nonnull BlockMenu inv) {
        LinkedList<ItemStack> parents = new LinkedList<ItemStack>();
        for (int slot : this.getInputSlots()) {
            ItemStack parent = inv.getItemInSlot(slot);
            if (parent == null) {
                return parents;
            }
            if (!ChickenUtils.isPocketChicken(parent) || !ChickenUtils.isAdult(parent)) continue;
            parents.add(parent);
        }
        return parents;
    }

    @Nullable
    protected MachineRecipe findNextRecipe(@Nonnull BlockMenu menu) {
        ConfigurationService config = GeneticChickengineering.getConfigService();
        List<ItemStack> parents = this.getParents(menu);
        if (parents.size() != 2) {
            return null;
        }
        ItemStack baby = ChickenUtils.breed(parents.get(0), parents.get(1));
        if (baby == null) {
            return null;
        }
        MachineRecipe recipe = new MachineRecipe(config.isTest() ? 1 : 60, new ItemStack[]{parents.get(0), parents.get(1)}, new ItemStack[]{baby});
        Inventory inv = menu.toInventory();
        inv.setMaxStackSize(1);
        if (!InvUtils.fitAll((Inventory)inv, (ItemStack[])recipe.getOutput(), (int[])this.getOutputSlots())) {
            return null;
        }
        if (GeneticChickengineering.getConfigService().isPainEnabled()) {
            for (ItemStack parent : parents) {
                if (!ChickenUtils.survivesPain(parent) && !GeneticChickengineering.getConfigService().isPainDeathEnabled()) {
                    return null;
                }
                ChickenUtils.possiblyHarm(parent);
                if (!(ChickenUtils.getHealth(parent) <= 0.0)) continue;
                ItemUtils.consumeItem((ItemStack)parent, (boolean)false);
                menu.getBlock().getWorld().playSound(menu.getLocation(), Sound.ENTITY_CHICKEN_DEATH, 1.0f, 1.0f);
                return null;
            }
        }
        return recipe;
    }
}

