/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.core.genetics;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;

public class Gene {
    private final char[] alleles;

    public Gene(char[] markup) {
        this.alleles = markup;
        Arrays.sort(this.alleles);
    }

    public Gene(char markup, int state) {
        this.alleles = new char[]{markup, markup};
        for (int i = 0; i < 2; ++i) {
            if ((state & i + 1) != i + 1) continue;
            this.alleles[i] = Character.toUpperCase(this.alleles[i]);
        }
    }

    public int getState() {
        int state = 0;
        for (int i = 0; i < 2; ++i) {
            if (!Character.isUpperCase(this.alleles[i])) continue;
            state = state + i + 1;
        }
        return state;
    }

    public boolean isDominant() {
        return this.getState() > 0;
    }

    public boolean isHeterozygous() {
        return this.alleles[0] == this.alleles[1];
    }

    public char split() {
        int ix = 0;
        if (ThreadLocalRandom.current().nextDouble() > 0.5) {
            ix = 1;
        }
        return this.alleles[ix];
    }

    public String toString() {
        return new String(this.alleles);
    }

    @Generated
    public char[] getAlleles() {
        return this.alleles;
    }
}

