/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.items.machines;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.genetics.DNA;
import net.guizhanss.gcereborn.core.services.ConfigurationService;
import net.guizhanss.gcereborn.items.chicken.PocketChicken;
import net.guizhanss.gcereborn.items.machines.AbstractMachine;
import net.guizhanss.gcereborn.utils.ChickenUtils;
import net.guizhanss.gcereborn.utils.Keys;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class GrowthChamber
extends AbstractMachine {
    public GrowthChamber(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    public ItemStack getProgressBar() {
        return new ItemStack(Material.WHEAT_SEEDS);
    }

    @Nullable
    protected MachineRecipe findNextRecipe(@Nonnull BlockMenu menu) {
        ConfigurationService config = GeneticChickengineering.getConfigService();
        ItemStack chicken = null;
        ItemStack seed = null;
        for (int slot : this.getInputSlots()) {
            ItemStack item = menu.getItemInSlot(slot);
            if (item == null || item.getType() == Material.AIR) continue;
            if (ChickenUtils.isPocketChicken(item) && !ChickenUtils.isAdult(item)) {
                chicken = item;
                continue;
            }
            if (!ChickenUtils.isFood(item) || item.getAmount() != item.getMaxStackSize()) continue;
            seed = item;
        }
        if (chicken == null || seed == null) {
            return null;
        }
        ItemStack output = chicken.clone();
        ItemMeta outputMeta = output.getItemMeta();
        JsonObject adapter = (JsonObject)PersistentDataAPI.get((PersistentDataHolder)outputMeta, (NamespacedKey)Keys.POCKET_CHICKEN_ADAPTER, PocketChicken.ADAPTER);
        int[] dnaState = PersistentDataAPI.getIntArray((PersistentDataHolder)outputMeta, (NamespacedKey)Keys.POCKET_CHICKEN_DNA);
        adapter.addProperty("baby", Boolean.valueOf(false));
        adapter.addProperty("_age", (Number)6000);
        adapter.addProperty("_breedable", Boolean.valueOf(false));
        ChickenUtils.setPocketChicken(output, adapter, new DNA(dnaState));
        MachineRecipe recipe = new MachineRecipe(config.isTest() ? 1 : config.getGrowthChamberTime(), new ItemStack[]{seed.clone(), chicken.clone()}, new ItemStack[]{output});
        if (!InvUtils.fitAll((Inventory)menu.toInventory(), (ItemStack[])recipe.getOutput(), (int[])this.getOutputSlots())) {
            return null;
        }
        ItemUtils.consumeItem((ItemStack)chicken, (boolean)false);
        ItemUtils.consumeItem((ItemStack)seed, (int)seed.getMaxStackSize(), (boolean)false);
        return recipe;
    }
}

