/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.core.services;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.utils.Keys;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataHolder;

@Deprecated(forRemoval=true)
public final class DatabaseService {
    private static final String DB_NAME = "GCE.db";
    private final String dbPath;
    private Connection conn;
    private boolean hasChanges = false;
    private Map<String, String> cache;

    public DatabaseService(GeneticChickengineering plugin) {
        this.dbPath = plugin.getDataFolder().getPath() + File.separator + DB_NAME;
        this.connect();
        if (this.isConnected()) {
            GeneticChickengineering.log(Level.INFO, GeneticChickengineering.getLocalization().getString("console.database.connected"), new Object[0]);
            this.createTables();
        }
    }

    public boolean isConnected() {
        return this.conn != null;
    }

    public boolean checkConnection() {
        if (!this.isConnected()) {
            GeneticChickengineering.log(Level.SEVERE, GeneticChickengineering.getLocalization().getString("console.database.not-connected"), new Object[0]);
            return false;
        }
        return true;
    }

    @Nonnull
    public Map<String, String> getAllChickens() {
        if (!this.hasChanges && this.cache != null) {
            return this.cache;
        }
        this.checkConnection();
        HashMap<String, String> chickens = new HashMap<String, String>();
        try {
            String sql = "SELECT uuid, dna FROM entities;";
            Statement stmt = this.conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                chickens.put(rs.getString("uuid"), rs.getString("dna"));
            }
            this.hasChanges = false;
            this.cache = chickens;
        }
        catch (SQLException ex) {
            GeneticChickengineering.log(Level.SEVERE, ex, GeneticChickengineering.getLocalization().getString("console.database.exception"), new Object[0]);
        }
        return chickens;
    }

    public boolean hasChicken(@Nonnull String uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"uuid cannot be null");
        return this.getAllChickens().containsKey(uuid);
    }

    public boolean hasChicken(@Nonnull UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"uuid cannot be null");
        return this.hasChicken(uuid.toString());
    }

    @Nullable
    public String getChickenDNA(@Nonnull String uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"uuid cannot be null");
        return this.getAllChickens().get(uuid);
    }

    public String getChickenDNA(@Nonnull UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"uuid cannot be null");
        return this.getChickenDNA(uuid.toString());
    }

    @ParametersAreNonnullByDefault
    public void addChicken(String uuid, String dna) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"uuid cannot be null");
        Preconditions.checkArgument((dna != null ? 1 : 0) != 0, (Object)"dna cannot be null");
        this.checkConnection();
        String sql = "INSERT INTO entities (uuid, dna) VALUES (?, ?);";
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            stmt.setString(1, uuid);
            stmt.setString(2, dna);
            stmt.executeUpdate();
            this.hasChanges = true;
        }
        catch (SQLException ex) {
            GeneticChickengineering.log(Level.SEVERE, ex, GeneticChickengineering.getLocalization().getString("console.database.exception"), new Object[0]);
        }
    }

    public void removeChicken(@Nonnull String uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"uuid cannot be null");
        this.checkConnection();
        String sql = "DELETE FROM entities WHERE uuid = ?;";
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            stmt.setString(1, uuid);
            stmt.executeUpdate();
            this.hasChanges = true;
        }
        catch (SQLException ex) {
            GeneticChickengineering.log(Level.SEVERE, ex, GeneticChickengineering.getLocalization().getString("console.database.exception"), new Object[0]);
        }
    }

    public void cleanup() {
        String uuid;
        Map<String, String> chickens = this.getAllChickens();
        if (chickens.isEmpty()) {
            return;
        }
        List worlds = GeneticChickengineering.getInstance().getServer().getWorlds();
        ArrayList<String> found = new ArrayList<String>();
        for (World world : worlds) {
            for (Map.Entry<String, String> entry : chickens.entrySet()) {
                Entity chick;
                uuid = entry.getKey();
                if (found.contains(uuid) || (chick = world.getEntity(UUID.fromString(uuid))) == null) continue;
                found.add(uuid);
                PersistentDataAPI.setString((PersistentDataHolder)chick, (NamespacedKey)Keys.CHICKEN_DNA, (String)entry.getValue());
            }
        }
        int validCount = 0;
        int invalidCount = 0;
        for (Map.Entry<String, String> entry : chickens.entrySet()) {
            uuid = entry.getKey();
            this.removeChicken(uuid);
            if (found.contains(uuid)) {
                ++validCount;
                continue;
            }
            ++invalidCount;
        }
        this.commit();
        if (invalidCount > 0) {
            GeneticChickengineering.log(Level.INFO, "Migrated {0} valid records and removed {1} invalid records from the database.", validCount, invalidCount);
        }
    }

    public void shutdown() {
        this.checkConnection();
        try {
            this.commit();
            this.conn.close();
        }
        catch (SQLException ex) {
            GeneticChickengineering.log(Level.SEVERE, ex, GeneticChickengineering.getLocalization().getString("console.database.exception"), new Object[0]);
        }
    }

    private void connect() {
        try {
            String url = "jdbc:sqlite:" + this.dbPath;
            this.conn = DriverManager.getConnection(url);
            this.conn.setAutoCommit(false);
        }
        catch (SQLException ex) {
            GeneticChickengineering.log(Level.SEVERE, ex, GeneticChickengineering.getLocalization().getString("console.database.connect-fail"), new Object[0]);
        }
    }

    private void createTables() {
        try {
            String sql = "CREATE TABLE IF NOT EXISTS entities (id INTEGER PRIMARY KEY AUTOINCREMENT,uuid TEXT NOT NULL,dna TEXT NOT NULL);";
            this.execSql(sql);
            this.commit();
        }
        catch (SQLException ex) {
            GeneticChickengineering.log(Level.SEVERE, ex, GeneticChickengineering.getLocalization().getString("console.database.exception"), new Object[0]);
        }
    }

    private void execSql(@Nonnull String sql) throws SQLException {
        if (!this.checkConnection()) {
            return;
        }
        GeneticChickengineering.debug("Prepare execute sql entry: {0}", sql);
        try (Statement stmt = this.conn.createStatement();){
            stmt.execute(sql);
        }
    }

    private void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException ex) {
            GeneticChickengineering.log(Level.SEVERE, ex, GeneticChickengineering.getLocalization().getString("console.database.exception"), new Object[0]);
        }
    }
}

