/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.libs.guizhanlib.common;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public final class Cooldown<K> {
    private final Map<K, Long> useMap = new HashMap<K, Long>();
    private final Map<K, Long> timeMap = new HashMap<K, Long>();

    public boolean check(@Nonnull K key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key should not be null");
        Long lastUse = this.useMap.get(key);
        Long cdTime = this.timeMap.get(key);
        if (lastUse == null || cdTime == null) {
            return true;
        }
        return System.nanoTime() - lastUse >= cdTime;
    }

    public void set(@Nonnull K key, long time) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key should not be null");
        this.useMap.put(key, System.nanoTime());
        this.timeMap.put(key, time * 1000000L);
    }
}

