/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.gcereborn.items.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.gcereborn.GeneticChickengineering;
import net.guizhanss.gcereborn.core.services.ConfigurationService;
import net.guizhanss.gcereborn.items.GCEItems;
import net.guizhanss.gcereborn.items.machines.AbstractMachine;
import net.guizhanss.gcereborn.utils.PocketChickenUtils;
import org.bukkit.Sound;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GeneticSequencer
extends AbstractMachine {
    public GeneticSequencer(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    public ItemStack getProgressBar() {
        return GCEItems.POCKET_CHICKEN.clone();
    }

    @Nullable
    protected MachineRecipe findNextRecipe(@Nonnull BlockMenu menu) {
        ConfigurationService config = GeneticChickengineering.getConfigService();
        for (int slot : this.getInputSlots()) {
            ItemStack item = menu.getItemInSlot(slot);
            if (!PocketChickenUtils.isPocketChicken(item) || PocketChickenUtils.isLearned(item)) continue;
            ItemStack chicken = item.clone();
            chicken.setAmount(1);
            ItemStack learnedChicken = PocketChickenUtils.learnDNA(chicken);
            if (config.isPainEnabled()) {
                if (!PocketChickenUtils.survivesPain(learnedChicken) && !config.isPainDeathEnabled()) continue;
                PocketChickenUtils.possiblyHarm(learnedChicken);
            }
            MachineRecipe recipe = new MachineRecipe(config.isTest() ? 1 : 30, new ItemStack[]{chicken}, new ItemStack[]{learnedChicken});
            if (!InvUtils.fitAll((Inventory)menu.toInventory(), (ItemStack[])recipe.getOutput(), (int[])this.getOutputSlots())) continue;
            if (config.isPainEnabled() && PocketChickenUtils.getHealth(learnedChicken) <= 0.0) {
                ItemUtils.consumeItem((ItemStack)chicken, (boolean)false);
                menu.getBlock().getWorld().playSound(menu.getLocation(), Sound.ENTITY_CHICKEN_DEATH, 1.0f, 1.0f);
                continue;
            }
            menu.consumeItem(slot, 1);
            return recipe;
        }
        return null;
    }
}

