/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.food;

import io.github.schntgaispock.gastronomicon.api.recipes.GastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.RecipeRegistry;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroStacks;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.UnplaceableSolid;
import io.github.schntgaispock.gastronomicon.util.StringUtil;
import io.github.schntgaispock.gastronomicon.util.collections.CollectionUtil;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SimpleGastroFood
extends UnplaceableSolid
implements RecipeDisplayItem {
    private final GastroRecipe gastroRecipe;
    protected final ItemStack topRightDisplayItem;

    public SimpleGastroFood(Research research, ItemGroup group, SlimefunItemStack item, GastroRecipe recipe, ItemStack topRightDisplayItem, ItemStack recipeDisplayOutput, boolean registerRecipe) {
        super(group, item, recipe.getRecipeType(), (ItemStack[])Arrays.stream(recipe.getInputs().getIngredients()).map(ingredient -> ingredient == null ? null : ingredient.getDisplayItem()).toArray(ItemStack[]::new), recipeDisplayOutput);
        this.gastroRecipe = recipe;
        this.topRightDisplayItem = topRightDisplayItem;
        this.setResearch(research);
        if (registerRecipe) {
            RecipeRegistry.registerRecipe(recipe);
        }
    }

    @Nonnull
    public String getRecipeSectionLabel(@Nonnull Player p) {
        return StringUtil.formatColors("&7Tools/Container Required:");
    }

    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ItemStack[] display = new ItemStack[18];
        display[0] = GastroStacks.GUIDE_TOOLS_REQUIRED;
        display[1] = GastroStacks.GUIDE_CONTAINER_REQUIRED;
        Object[] tools = (ItemStack[])this.getGastroRecipe().getTools().toArray(ItemStack[]::new);
        ItemStack container = this.getGastroRecipe().getInputs().getContainer().getDisplayItem();
        display[2] = CollectionUtil.isEmpty(tools) ? GastroStacks.GUIDE_NONE : tools[0];
        display[3] = container == null || container.getType() == Material.AIR ? GastroStacks.GUIDE_NONE : container;
        for (int i = 1; i < tools.length; ++i) {
            display[2 + 2 * i] = tools[i];
            display[3 + 2 * i] = new ItemStack(Material.AIR);
        }
        display[16] = this.topRightDisplayItem;
        display[17] = this.getGastroRecipe().getInputs().getShapedness().getGuideItem();
        return Arrays.asList(display);
    }

    @Generated
    public GastroRecipe getGastroRecipe() {
        return this.gastroRecipe;
    }

    @Generated
    public ItemStack getTopRightDisplayItem() {
        return this.topRightDisplayItem;
    }
}

