/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.food;

import io.github.schntgaispock.gastronomicon.api.food.SimpleGastroFoodBuilder;
import io.github.schntgaispock.gastronomicon.api.items.FoodItemStack;
import io.github.schntgaispock.gastronomicon.api.recipes.GastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.MultiStoveRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.ShapedGastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.ShapelessGastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.components.RecipeComponent;
import io.github.schntgaispock.gastronomicon.api.recipes.components.SingleRecipeComponent;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroGroups;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroResearch;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.food.GastroFood;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual.MultiStove;
import io.github.schntgaispock.gastronomicon.core.slimefun.recipes.GastroRecipeType;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class GastroFoodBuilder
extends SimpleGastroFoodBuilder {
    protected Research research = GastroResearch.FOOD;
    protected ItemGroup group = GastroGroups.FOOD;
    protected FoodItemStack itemStack;

    @Override
    public GastroFoodBuilder research(Research research) {
        this.research = research;
        return this;
    }

    @Override
    public GastroFoodBuilder group(@Nonnull ItemGroup group) {
        this.group = group;
        return this;
    }

    public GastroFoodBuilder item(@Nonnull FoodItemStack itemStack) {
        this.itemStack = itemStack;
        return this;
    }

    @Override
    public GastroFoodBuilder amount(int amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public GastroFoodBuilder type(@Nonnull GastroRecipeType type) {
        this.recipeType = type;
        return this;
    }

    @Override
    public GastroFoodBuilder shape(@Nonnull GastroRecipe.RecipeShape shape) {
        this.shape = shape;
        return this;
    }

    @Override
    public GastroFoodBuilder temperature(@Nonnull MultiStove.Temperature temperature) {
        this.temperature = temperature;
        return this;
    }

    @Override
    public GastroFoodBuilder ingredients(Object ... ingredients) {
        this.ingredients = new RecipeComponent[9];
        for (int i = 0; i < Math.min(ingredients.length, 9); ++i) {
            String str;
            SlimefunItem item;
            Object object = ingredients[i];
            if (object instanceof ItemStack) {
                ItemStack stack = (ItemStack)object;
                this.ingredients[i] = new SingleRecipeComponent(stack);
                continue;
            }
            object = ingredients[i];
            if (object instanceof RecipeComponent) {
                RecipeComponent comp;
                this.ingredients[i] = comp = (RecipeComponent)object;
                continue;
            }
            object = ingredients[i];
            if (object instanceof Material) {
                Material mat = (Material)object;
                this.ingredients[i] = new SingleRecipeComponent(new ItemStack(mat));
                continue;
            }
            object = ingredients[i];
            this.ingredients[i] = object instanceof String ? ((item = SlimefunItem.getById((String)(str = (String)object))) == null ? RecipeComponent.EMPTY : new SingleRecipeComponent(item.getItem())) : RecipeComponent.EMPTY;
        }
        return this;
    }

    @Override
    public GastroFoodBuilder ingredients(ItemStack ... ingredients) {
        this.ingredients = new RecipeComponent[9];
        for (int i = 0; i < Math.min(ingredients.length, 9); ++i) {
            this.ingredients[i] = ingredients[i] == null || ingredients[i].getType() == Material.AIR ? RecipeComponent.EMPTY : new SingleRecipeComponent(ingredients[i]);
        }
        return this;
    }

    @Override
    public GastroFoodBuilder ingredients(RecipeComponent<?> ... ingredients) {
        this.ingredients = Arrays.copyOf(ingredients, 9);
        return this;
    }

    @Override
    public GastroFoodBuilder container(@Nonnull ItemStack stack) {
        this.container = new SingleRecipeComponent(stack);
        return this;
    }

    @Override
    public GastroFoodBuilder container(@Nonnull RecipeComponent<?> comp) {
        this.container = comp;
        return this;
    }

    @Override
    public GastroFoodBuilder tools(ItemStack ... tools) {
        this.tools = Set.of(tools);
        return this;
    }

    @Override
    public GastroFood build() {
        GastroRecipe recipe;
        ItemStack topRightDisplayItem;
        Validate.notNull((Object)((Object)this.itemStack), (String)"Must set an ItemStack!");
        Validate.notNull((Object)((Object)this.recipeType), (String)"Must set a recipe type!");
        ItemStack[] outputs = new ItemStack[]{this.itemStack.asQuantity(this.amount), this.itemStack.asPerfect().asQuantity(this.amount)};
        if (this.recipeType == GastroRecipeType.MULTI_STOVE) {
            topRightDisplayItem = this.temperature.getItem().clone();
            topRightDisplayItem.setLore(Collections.emptyList());
            recipe = new MultiStoveRecipe(this.ingredients, this.container, (Set<ItemStack>)this.tools, outputs, this.temperature);
        } else {
            topRightDisplayItem = new ItemStack(Material.AIR);
            recipe = this.shape == GastroRecipe.RecipeShape.SHAPED ? new ShapedGastroRecipe(this.recipeType, this.ingredients, this.container, (Set<ItemStack>)this.tools, outputs) : new ShapelessGastroRecipe(this.recipeType, this.ingredients, this.container, (Set<ItemStack>)this.tools, outputs);
        }
        return new GastroFood(this.research, this.group, this.itemStack, recipe, topRightDisplayItem, outputs[0], false);
    }

    @Override
    @Nonnull
    @Generated
    public String toString() {
        return "GastroFoodBuilder(research=" + this.research + ", group=" + this.group + ", itemStack=" + this.itemStack + ")";
    }
}

