/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.food;

import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.util.NumberUtil;
import io.github.schntgaispock.gastronomicon.util.item.ItemUtil;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class FoodEffect {
    private static final double PERFECT_MULTIPLIER_HEALTH = 1.25;
    private static final double PERFECT_MULTIPLIER_DURATION = 1.25;
    private static final double PERFECT_MULTIPLIER_XP = 1.25;
    private static final double PERFECT_MULTIPLIER_ITEM_AMOUNT = 1.5;
    private static final double PERFECT_MULTIPLIER_AIR = 1.5;
    private static final double PERFECT_MULTIPLIER_WARM = 1.5;
    private static final double PERFECT_MULTIPLIER_TELEPORT = 1.25;
    private static final double PERFECT_MULTIPLIER_CHANCE = 1.5;
    private static final double PERFECT_MULTIPLIER_VELOCITY = 1.25;
    private static final int PERFECT_BONUS_POTION_LEVEL = 1;
    @Nonnull
    private final String description;
    @Nonnull
    private final String perfectDescription;
    @Nonnull
    private final BiConsumer<Player, Boolean> application;
    private static final FoodEffect extinguish = new FoodEffect("&fExtinguish yourself", (player, isPerfect) -> player.setFireTicks(0));
    private static final FoodEffect clearPotionEffects = new FoodEffect("&fClear all effects", (player, isPerfect) -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "/effect " + player.getName() + " clear"));

    public FoodEffect(String description, BiConsumer<Player, Boolean> application) {
        this(description, description, application);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect chanceOf(FoodEffect effect, double chance) {
        double pc = chance * 1.5;
        return new FoodEffect(effect.getDescription() + " &8(" + NumberUtil.roundToPercent(chance, 4) + "%)", effect.getPerfectDescription() + " &8(" + NumberUtil.roundToPercent(pc, 4) + "%)", (player, isPerfect) -> {
            if (NumberUtil.flip(isPerfect != false ? pc : chance)) {
                effect.apply((Player)player, (boolean)isPerfect);
            }
        });
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect heal(int health) {
        int h = Math.max(health, 1);
        int ph = (int)Math.ceil((double)h * 1.25);
        return new FoodEffect("&aHealth +" + h, "&aHealth +" + ph, (player, isPerfect) -> player.setHealth(Math.min(player.getHealth() + (double)(isPerfect != false ? ph : h), player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue())));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private static FoodEffect potionEffect(String color, PotionEffectType effectType, int durationSeconds, int amplifier, boolean ambience, boolean particles, boolean icon) {
        int d = Math.max(durationSeconds, 1);
        int pd = (int)Math.ceil((double)d * 1.25);
        int a = Math.max(amplifier, 0);
        int pa = amplifier + 1;
        return new FoodEffect(color + ItemUtil.getPotionName(effectType) + " " + NumberUtil.asRomanNumeral(a + 1) + " (" + d + "s)", color + ItemUtil.getPotionName(effectType) + " " + NumberUtil.asRomanNumeral(pa + 1) + " (" + pd + "s)", (player, isPerfect) -> player.addPotionEffect(new PotionEffect(effectType, 20 * (isPerfect != false ? pd : d), isPerfect != false ? pa : a, ambience, particles, icon)));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect positivePotionEffect(PotionEffectType effectType, int durationSeconds, int amplifier, boolean ambience, boolean particles, boolean icon) {
        return FoodEffect.potionEffect("&9", effectType, durationSeconds, amplifier, ambience, particles, icon);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect positivePotionEffect(PotionEffectType effectType, int durationSeconds, int amplifier, boolean ambience, boolean particles) {
        return FoodEffect.positivePotionEffect(effectType, durationSeconds, amplifier, ambience, particles, particles);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect positivePotionEffect(PotionEffectType effectType, int durationSeconds, int amplifier, boolean ambience) {
        return FoodEffect.positivePotionEffect(effectType, durationSeconds, amplifier, ambience, true);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect positivePotionEffect(PotionEffectType effectType, int durationSeconds, int amplifier) {
        return FoodEffect.positivePotionEffect(effectType, durationSeconds, amplifier, true);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect positivePotionEffect(PotionEffectType effectType, int durationSeconds) {
        return FoodEffect.positivePotionEffect(effectType, durationSeconds, 0);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect positivePotionEffect(PotionEffect effect) {
        return FoodEffect.positivePotionEffect(effect.getType(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles(), effect.hasIcon());
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect negativePotionEffect(PotionEffectType effectType, int durationSeconds, int amplifier, boolean ambience, boolean particles, boolean icon) {
        return FoodEffect.potionEffect("&c", effectType, durationSeconds, amplifier, ambience, particles, icon);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect negativePotionEffect(PotionEffectType effectType, int durationSeconds, int amplifier, boolean ambience, boolean particles) {
        return FoodEffect.negativePotionEffect(effectType, durationSeconds, amplifier, ambience, particles, particles);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect negativePotionEffect(PotionEffectType effectType, int durationSeconds, int amplifier, boolean ambience) {
        return FoodEffect.negativePotionEffect(effectType, durationSeconds, amplifier, ambience, true);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect negativePotionEffect(PotionEffectType effectType, int durationSeconds, int amplifier) {
        return FoodEffect.negativePotionEffect(effectType, durationSeconds, amplifier, true);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect negativePotionEffect(PotionEffectType effectType, int durationSeconds) {
        return FoodEffect.negativePotionEffect(effectType, durationSeconds, 0);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect negativePotionEffect(PotionEffect effect) {
        return FoodEffect.negativePotionEffect(effect.getType(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles(), effect.hasIcon());
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect removePotionEffect(PotionEffectType type) {
        String desc = "&bClears " + ItemUtil.getPotionName(type) + " effects";
        return new FoodEffect(desc, desc, (player, isPerfect) -> player.removePotionEffect(type));
    }

    @Nonnull
    public static FoodEffect xp(int xp) {
        int x = Math.max(xp, 1);
        int px = (int)Math.ceil((double)x * 1.25);
        return new FoodEffect("&eXP +" + Math.round(x), "&eXP +" + px, (player, isPerfect) -> player.giveExp(isPerfect != false ? px : x));
    }

    private static FoodEffect _giveItem(ItemStack item) {
        int a = item.getAmount();
        int pa = (int)Math.ceil((double)a * 1.5);
        String name = item.hasItemMeta() ? item.getItemMeta().getDisplayName() : item.getType().name();
        return new FoodEffect("&7Gives " + a + "x " + name, "&7Gives " + pa + "x " + name, (player, isPerfect) -> player.getInventory().addItem(new ItemStack[]{item}));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect giveItem(ItemStack item, int amount) {
        ItemStack clone = item.clone();
        clone.setAmount(amount);
        return FoodEffect._giveItem(item);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect giveItem(ItemStack item) {
        return FoodEffect._giveItem(item.clone());
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect giveItem(Material material, int amount) {
        return FoodEffect._giveItem(new ItemStack(material, amount));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static FoodEffect giveItem(Material material) {
        return FoodEffect._giveItem(new ItemStack(material));
    }

    public static FoodEffect giveSlimefunItem(@Nonnull String id, int amount) {
        SlimefunItem sfItem = SlimefunItem.getById((String)id);
        if (sfItem == null) {
            Gastronomicon.log(Level.WARNING, "Cannot produce a FoodEffect that gives Slimefun item \"" + id + "\" because it doesn't exist. Make sure to keep Slimefun and addons up to date!");
            return FoodEffect.giveItem(Material.AIR, 1);
        }
        return FoodEffect.giveItem(sfItem.getItem());
    }

    public static FoodEffect giveSlimefunItem(@Nonnull String id) {
        SlimefunItem sfItem = SlimefunItem.getById((String)id);
        if (sfItem == null) {
            Gastronomicon.log(Level.WARNING, "Cannot produce a FoodEffect that gives Slimefun item \"" + id + "\" because it doesn't exist. Make sure to keep Slimefun and addons up to date!");
            return FoodEffect.giveItem(Material.AIR, 1);
        }
        return FoodEffect.giveItem(sfItem.getItem().clone());
    }

    public static FoodEffect air(int amount) {
        int a = Math.max(amount, 1);
        int pa = (int)Math.ceil((double)a * 1.5);
        return new FoodEffect("&fAir +" + a, "&fAir +" + pa, (player, isPerfect) -> player.setRemainingAir(Math.min(player.getRemainingAir() + (isPerfect != false ? pa : a), 20)));
    }

    public static FoodEffect warm(int amount) {
        int a = Math.max(amount, 1);
        int pa = (int)Math.ceil((double)a * 1.5);
        return new FoodEffect("&6Warmth +" + a, "&6Warmth +" + pa, (player, isPerfect) -> player.setFreezeTicks(Math.max(player.getFreezeTicks() - (isPerfect != false ? pa : a), 0)));
    }

    public static FoodEffect teleport(int radius) {
        int r = NumberUtil.clamp(radius, 1, 10);
        int pr = (int)Math.ceil((double)r * 1.25);
        return new FoodEffect("&7Teleports you somewhere within " + r + " blocks away", "&7Teleports you somewhere within " + pr + " blocks away", (player, isPerfect) -> {
            Location playerLocation = player.getLocation();
            int playerX = playerLocation.getBlockX();
            int playerY = playerLocation.getBlockY();
            int playerZ = playerLocation.getBlockZ();
            int teleportRadius = isPerfect != false ? pr : r;
            int i = 0;
            while ((double)i < 10.0 + Math.pow(r, 3.0)) {
                int newX = playerX + NumberUtil.getRandom().nextInt(teleportRadius);
                int newY = playerY + NumberUtil.getRandom().nextInt(teleportRadius);
                int newZ = playerZ + NumberUtil.getRandom().nextInt(teleportRadius);
                if (player.getWorld().getBlockAt(newX, newY - 1, newZ).getType().isSolid() && player.getWorld().getBlockAt(newX, newY, newZ).isEmpty() && player.getWorld().getBlockAt(newX, newY + 1, newZ).isEmpty()) {
                    Vector facing = player.getLocation().getDirection();
                    player.teleport(new Location(player.getWorld(), (double)newX, (double)newY, (double)newZ));
                    player.getLocation().setDirection(facing);
                    player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    return;
                }
                ++i;
            }
            player.playSound(player.getLocation(), Sound.ENTITY_ENDERMITE_AMBIENT, SoundCategory.PLAYERS, 1.0f, 1.0f);
        });
    }

    public static FoodEffect move(Vector velocity, String description) {
        Vector pv = velocity.multiply(1.25);
        return new FoodEffect(description, description, (player, isPerfect) -> player.setVelocity(player.getVelocity().add(isPerfect != false ? pv : velocity)));
    }

    public static FoodEffect extinguish() {
        return extinguish;
    }

    public static FoodEffect clearPotionEffects() {
        return clearPotionEffects;
    }

    public void apply(Player player, boolean isPerfect) {
        this.application.accept(player, isPerfect);
    }

    @Generated
    public FoodEffect(@Nonnull String description, @Nonnull String perfectDescription, @Nonnull BiConsumer<Player, Boolean> application) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (perfectDescription == null) {
            throw new NullPointerException("perfectDescription is marked non-null but is null");
        }
        if (application == null) {
            throw new NullPointerException("application is marked non-null but is null");
        }
        this.description = description;
        this.perfectDescription = perfectDescription;
        this.application = application;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "FoodEffect(description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FoodEffect)) {
            return false;
        }
        FoodEffect other = (FoodEffect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FoodEffect;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    @Generated
    public String getPerfectDescription() {
        return this.perfectDescription;
    }
}

