/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon;

import io.github.schntgaispock.bstats.bukkit.Metrics;
import io.github.schntgaispock.bstats.charts.SimplePie;
import io.github.schntgaispock.gastronomicon.api.trees.TreeStructure;
import io.github.schntgaispock.gastronomicon.core.setup.CommandSetup;
import io.github.schntgaispock.gastronomicon.core.setup.ItemSetup;
import io.github.schntgaispock.gastronomicon.core.setup.ListenerSetup;
import io.github.schntgaispock.gastronomicon.core.setup.ResearchSetup;
import io.github.schntgaispock.gastronomicon.integration.DynaTechSetup;
import io.github.schntgaispock.gastronomicon.integration.SlimeHUDSetup;
import io.github.schntgaispock.gastronomicon.util.StringUtil;
import io.github.schntgaispock.infinitylib.core.AbstractAddon;
import io.github.schntgaispock.infinitylib.core.AddonConfig;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Gastronomicon
extends AbstractAddon {
    private static Gastronomicon instance;
    private AddonConfig playerData;
    private AddonConfig customFood;

    public Gastronomicon() {
        super("SchnTgaiSpock", "Gastronomicon", "master", "options.auto-update");
    }

    @Override
    public void enable() {
        instance = this;
        Gastronomicon.info("#======================================#");
        Gastronomicon.info("#    Gastronomicon by SchnTgaiSpock    #");
        Gastronomicon.info("#======================================#");
        if (this.getConfig().getBoolean("options.auto-update")) {
            if (this.getDescription().getVersion().startsWith("Dev - ")) {
                new BlobBuildUpdater((Plugin)this, this.getFile(), "Gastronomicon", "Dev").start();
            } else {
                Gastronomicon.info("This is an unofficial build of Gastronomicon, so auto updates are disabled!");
                Gastronomicon.info("You can download the official build here: https://blob.build/project/Gastronomicon");
            }
        }
        Metrics metrics = new Metrics(this, 16941);
        metrics.addCustomChart(new SimplePie("exoticgardenInstalled", () -> Boolean.toString(Gastronomicon.isPluginEnabled("ExoticGarden"))));
        ItemSetup.setup();
        ResearchSetup.setup();
        ListenerSetup.setup();
        CommandSetup.setup();
        if (Gastronomicon.isPluginEnabled("SlimeHUD")) {
            try {
                Gastronomicon.info("SlimeHUD was found on this server!");
                Gastronomicon.info("Setting up Gastronomicon for SlimeHUD...");
                SlimeHUDSetup.setup();
            }
            catch (NoClassDefFoundError e) {
                Gastronomicon.warn("This server is using an incompatitable version of SlimeHUD");
                Gastronomicon.warn("Please update SlimeHUD to version 1.2.0 or higher!");
            }
        }
        if (!this.getConfig().getBoolean("disable-exotic-garden-recipes") && !Gastronomicon.isPluginEnabled("ExoticGarden")) {
            Gastronomicon.warn("ExoticGarden was not found on this server!");
            Gastronomicon.warn("Recipes that require ExoticGarden items will be hidden.");
        }
        if (Gastronomicon.isPluginEnabled("DynaTech") && !this.getConfig().getBoolean("disable-dynatech-integration")) {
            try {
                Gastronomicon.info("DynaTech was found on this server!");
                Gastronomicon.info("Registering Gastronomicon crops with DynaTech...");
                DynaTechSetup.setup();
            }
            catch (NoClassDefFoundError e) {
                Gastronomicon.warn("This server is using an incompatitable version of DynaTech");
                Gastronomicon.warn("Please keep Gastronomicon and DynaTech up to date!");
            }
        }
        this.playerData = new AddonConfig("player.yml");
        this.customFood = new AddonConfig("custom-food.yml");
        TreeStructure.loadTrees();
    }

    @Override
    public void disable() {
        instance = null;
        this.getPlayerData().save();
    }

    public static NamespacedKey key(@Nonnull String name) {
        return new NamespacedKey((Plugin)Gastronomicon.getInstance(), name);
    }

    public static boolean isPluginEnabled(String name) {
        return Gastronomicon.getInstance().getServer().getPluginManager().isPluginEnabled(name);
    }

    public static int scheduleSyncDelayedTask(Runnable runnable, long delay) {
        return Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Gastronomicon.getInstance(), runnable, delay);
    }

    public static BukkitTask scheduleSyncRepeatingTask(Runnable runnable, long delay, long interval) {
        return Bukkit.getScheduler().runTaskTimer((Plugin)Gastronomicon.getInstance(), runnable, delay, interval);
    }

    public static boolean checkPermission(Player player, @Nonnull String permissionNode, @Nullable String message) {
        if (player.hasPermission(permissionNode)) {
            return true;
        }
        if (message != null) {
            Gastronomicon.sendMessage(player, message);
        }
        return false;
    }

    public static void info(String message) {
        Gastronomicon.getInstance().getLogger().info(message);
    }

    public static void warn(String message) {
        Gastronomicon.getInstance().getLogger().warning(message);
    }

    public static void error(String message) {
        Gastronomicon.getInstance().getLogger().severe(message);
    }

    public static void sendMessage(Player player, String message) {
        player.sendMessage(StringUtil.formatColors(message));
    }

    public static void sendMessage(Player player, Component message) {
        Component text = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Gastronomicon").color(TextColor.color((int)201, (int)29, (int)244))).decorate(TextDecoration.BOLD)).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(">").color(TextColor.color((int)170, (int)170, (int)170))).decorate(TextDecoration.BOLD)).appendSpace()).asComponent())).asComponent();
        player.sendMessage(text);
    }

    @Generated
    public AddonConfig getPlayerData() {
        return this.playerData;
    }

    @Generated
    public AddonConfig getCustomFood() {
        return this.customFood;
    }

    @Generated
    public static Gastronomicon getInstance() {
        return instance;
    }
}

