/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.util;

import io.github.schntgaispock.gastronomicon.api.recipes.components.RecipeComponent;
import io.github.schntgaispock.gastronomicon.util.NumberUtil;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.Arrays;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class RecipeUtil {
    public static ItemStack[] empty() {
        return new ItemStack[9];
    }

    public static ItemStack[] single(ItemStack item) {
        ItemStack[] recipe = new ItemStack[9];
        recipe[0] = item;
        return recipe;
    }

    public static ItemStack[] singleCenter(Material item) {
        ItemStack[] recipe = new ItemStack[9];
        recipe[4] = new ItemStack(item);
        return recipe;
    }

    public static ItemStack[] singleCenter(ItemStack item) {
        ItemStack[] recipe = new ItemStack[9];
        recipe[4] = item;
        return recipe;
    }

    public static ItemStack[] collection(ItemStack ... items) {
        return RecipeUtil.collection(items, 9);
    }

    private static ItemStack[] collection(ItemStack[] items, int maxLength) {
        ItemStack[] recipe = new ItemStack[9];
        int l = Math.min(items.length, maxLength);
        for (int i = 0; i < l; ++i) {
            recipe[i] = items[i];
        }
        return recipe;
    }

    public static ItemStack[] cyclic(ItemStack outer, ItemStack inner) {
        return new ItemStack[]{outer, outer, outer, outer, inner, outer, outer, outer, outer};
    }

    public static ItemStack[] cyclic(ItemStack outer) {
        return RecipeUtil.cyclic(outer, null);
    }

    public static ItemStack[] cyclicAlternating(ItemStack corner, ItemStack middle, ItemStack inner) {
        return new ItemStack[]{corner, middle, corner, middle, inner, middle, corner, middle, corner};
    }

    public static ItemStack[] cyclicAlternating(ItemStack corner, ItemStack middle) {
        return RecipeUtil.cyclicAlternating(corner, middle, null);
    }

    public static ItemStack[] row(ItemStack item, int rowNumber) {
        int rowStart = NumberUtil.clamp(rowNumber, 0, 2) * 3;
        ItemStack[] recipe = new ItemStack[9];
        ItemStack itemStack = item;
        recipe[rowStart + 2] = itemStack;
        recipe[rowStart + 1] = itemStack;
        recipe[rowStart] = itemStack;
        return recipe;
    }

    public static ItemStack[] column(ItemStack item, int colNumber) {
        int colStart = NumberUtil.clamp(colNumber, 0, 2);
        ItemStack[] recipe = new ItemStack[9];
        ItemStack itemStack = item;
        recipe[colStart + 6] = itemStack;
        recipe[colStart + 3] = itemStack;
        recipe[colStart] = itemStack;
        return recipe;
    }

    public static ItemStack[] diagonal(ItemStack item, int slope) {
        ItemStack[] recipe = new ItemStack[9];
        if (slope == 1) {
            recipe[4] = recipe[6] = item;
            recipe[2] = recipe[6];
        } else if (slope == -1) {
            recipe[4] = recipe[8] = item;
            recipe[0] = recipe[8];
        }
        return recipe;
    }

    public static ItemStack[] block(ItemStack item) {
        Object[] recipe = new ItemStack[9];
        Arrays.fill(recipe, item);
        return recipe;
    }

    public static int compareComponents(RecipeComponent<?> component1, RecipeComponent<?> component2) {
        return Integer.compare(RecipeUtil.recipeHash(component1 == null ? null : component1.getComponent()), RecipeUtil.recipeHash(component2 == null ? null : component2.getComponent()));
    }

    public static int compareItemStacks(ItemStack item1, ItemStack item2) {
        return Integer.compare(RecipeUtil.recipeHash(item1 == null ? null : item1), RecipeUtil.recipeHash(item2 == null ? null : item2));
    }

    public static int recipeHash(Object object) {
        if (object == null) {
            return Integer.MAX_VALUE;
        }
        if (object instanceof SlimefunItemStack) {
            SlimefunItemStack sfStack = (SlimefunItemStack)object;
            return sfStack.getItemId().hashCode();
        }
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)stack);
            if (sfItem != null) {
                return sfItem.getId().hashCode();
            }
            return stack.getType().hashCode();
        }
        return object.hashCode();
    }

    @Generated
    private RecipeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

