/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual;

import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.api.recipes.GastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.MultiStoveRecipe;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual.GastroWorkstation;
import io.github.schntgaispock.gastronomicon.core.slimefun.recipes.GastroRecipeType;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MultiStove
extends GastroWorkstation
implements EnergyNetComponent {
    public static final ItemStack TEMPERATURE_BUTTON_LOW = new CustomItemStack(Material.YELLOW_STAINED_GLASS_PANE, "&7Temperature: &eLOW", new String[]{"", "&bLeft-click &7to increase"});
    public static final ItemStack TEMPERATURE_BUTTON_MEDIUM = new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, "&7Temperature: &6MEDIUM", new String[]{"", "&bLeft-click &7to increase", "&bRight-click &7to decrease"});
    public static final ItemStack TEMPERATURE_BUTTON_HIGH = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&7Temperature: &cHIGH", new String[]{"", "&bRight-click &7to decrease"});
    public static final int TEMPERATURE_BUTTON_SLOT = 52;
    public static final String TEMPERATURE_KEY = "gastronomicon:multi_stove/temperature";
    private final int capacity;
    private final int energyPerUse;

    public MultiStove(SlimefunItemStack item, ItemStack[] recipe, int capacity, int energyPerUse) {
        super(item, recipe);
        this.capacity = capacity;
        this.energyPerUse = energyPerUse;
    }

    @Override
    protected void setup(BlockMenuPreset preset) {
        super.setup(preset);
        preset.drawBackground(TEMPERATURE_BUTTON_LOW, new int[]{52});
    }

    @Override
    protected void onNewInstance(BlockMenu menu, Block b) {
        super.onNewInstance(menu, b);
        menu.addMenuOpeningHandler(player -> {
            String temp = BlockStorage.getLocationInfo((Location)menu.getLocation(), (String)TEMPERATURE_KEY);
            menu.replaceExistingItem(52, temp == null ? TEMPERATURE_BUTTON_LOW : Temperature.valueOf(temp).getItem(), false);
        });
        menu.addMenuClickHandler(52, (player, slot, item, action) -> {
            Temperature t = Temperature.valueOf(item.getItemMeta().getDisplayName().substring(17));
            MultiStove.changeTemperature(menu, action.isRightClicked() ? t.prev() : t.next());
            return false;
        });
    }

    public static void changeTemperature(@Nonnull BlockMenu menu, @Nullable Temperature t) {
        if (t == null) {
            return;
        }
        menu.replaceExistingItem(52, t.getItem());
        BlockStorage.addBlockInfo((Location)menu.getLocation(), (String)TEMPERATURE_KEY, (String)t.name());
    }

    @Override
    public GastroRecipeType getGastroRecipeType() {
        return GastroRecipeType.MULTI_STOVE;
    }

    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    @Override
    @Nullable
    protected GastroRecipe findRecipe(ItemStack[] ingredients, List<ItemStack> containers, List<ItemStack> tools, Player player, BlockMenu menu) {
        GastroRecipe recipe = super.findRecipe(ingredients, containers, tools, player, menu);
        if (recipe instanceof MultiStoveRecipe) {
            MultiStoveRecipe msRecipe = (MultiStoveRecipe)recipe;
            if (msRecipe.getTemperature().getItem().isSimilar(menu.getItemInSlot(52))) {
                return msRecipe;
            }
            return null;
        }
        return recipe;
    }

    @Override
    protected int getOtherHash(Player player, BlockMenu menu) {
        return menu.getItemInSlot(52).getType().ordinal();
    }

    @Override
    protected boolean canCraft(BlockMenu menu, Block b, Player p, boolean sendMessage) {
        int charge = this.getCharge(b.getLocation());
        if (charge < this.getEnergyPerUse()) {
            Gastronomicon.sendMessage(p, "&eNot enough energy!");
            return false;
        }
        return true;
    }

    @Override
    protected void onSuccessfulCraft(Block b) {
        int charge = this.getCharge(b.getLocation());
        this.setCharge(b.getLocation(), charge - this.getEnergyPerUse());
    }

    @Generated
    public int getCapacity() {
        return this.capacity;
    }

    @Generated
    public int getEnergyPerUse() {
        return this.energyPerUse;
    }

    public static enum Temperature {
        LOW(TEMPERATURE_BUTTON_LOW),
        MEDIUM(TEMPERATURE_BUTTON_MEDIUM),
        HIGH(TEMPERATURE_BUTTON_HIGH);

        private final ItemStack item;

        @Nullable
        public Temperature next() {
            if (this.ordinal() == Temperature.values().length - 1) {
                return null;
            }
            return Temperature.values()[this.ordinal() + 1];
        }

        @Nullable
        public Temperature prev() {
            if (this.ordinal() == 0) {
                return null;
            }
            return Temperature.values()[this.ordinal() - 1];
        }

        @Generated
        private Temperature(ItemStack item) {
            this.item = item;
        }

        @Generated
        public ItemStack getItem() {
            return this.item;
        }
    }
}

