/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds;

import io.github.schntgaispock.gastronomicon.core.slimefun.GastroGroups;
import io.github.schntgaispock.gastronomicon.core.slimefun.recipes.GastroRecipeType;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractSeed
extends SlimefunItem {
    @ParametersAreNonnullByDefault
    public AbstractSeed(SlimefunItemStack item, ItemStack[] gatherSources) {
        super((ItemGroup)GastroGroups.RAW_INGREDIENTS, item, (RecipeType)GastroRecipeType.BREAK, gatherSources);
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockBreakHandler(false, true){

            public void onExplode(Block b, List<ItemStack> drops) {
                drops.clear();
                drops.addAll(AbstractSeed.this.getHarvestDrops(b.getState(), new ItemStack(Material.AIR), false));
            }

            public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
                if (!AbstractSeed.this.dropsOnPlayerBreak()) {
                    return;
                }
                drops.clear();
                drops.addAll(AbstractSeed.this.getHarvestDrops(e.getBlock().getState(), item, true));
            }
        }});
    }

    public abstract List<ItemStack> getHarvestDrops(BlockState var1, ItemStack var2, boolean var3);

    protected boolean dropsOnPlayerBreak() {
        return true;
    }

    public abstract boolean isMature(BlockState var1);
}

