/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.command;

import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.api.items.GastroTheme;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.food.GastroFood;
import io.github.schntgaispock.infinitylib.core.AddonConfig;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GastroCommandExecutor
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        switch (args.length) {
            case 0: {
                this.sendInfo(player);
                return true;
            }
            case 1: {
                switch (args[0]) {
                    case "help": {
                        this.sendHelp(player);
                        return true;
                    }
                    case "profile": {
                        return this.commandProfile(player);
                    }
                    case "credits": {
                        this.sendCredits(player);
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                switch (args[0]) {
                    case "profile": {
                        Player toCheck = Bukkit.getServer().getPlayer(args[1]);
                        if (toCheck == null) {
                            Gastronomicon.sendMessage(player, "&cUnknown player!");
                            return true;
                        }
                        return this.commandProfile(player, toCheck);
                    }
                }
                return false;
            }
            case 4: {
                if (args[0].equals("proficiency") && args[1].equals("get")) {
                    Player target = Bukkit.getServer().getPlayerExact(args[3]);
                    if (target == null) {
                        Gastronomicon.sendMessage(player, "&cUnknown player!");
                        return false;
                    }
                    if (target.getUniqueId() == player.getUniqueId()) {
                        return this.commandProficiencyGet(player, args[2]);
                    }
                    return this.commandProficiencyGet(player, target, args[2]);
                }
                return false;
            }
            case 5: {
                switch (args[0]) {
                    case "proficiency": {
                        int amount;
                        if (!Gastronomicon.checkPermission(player, "gastronomicon.modifyprofile", GastroTheme.PERFECT_FOOD.getColor() + "\u00a7lGastronomicon&7> &cYou do not have permission to modify profiles!")) {
                            return true;
                        }
                        try {
                            amount = Integer.parseInt(args[3]);
                        }
                        catch (NumberFormatException e) {
                            Gastronomicon.sendMessage(player, "&cAmount must be a number!");
                            return true;
                        }
                        if (amount < 0) {
                            Gastronomicon.sendMessage(player, "&cAmount must be positive!");
                            return true;
                        }
                        Player target = Bukkit.getServer().getPlayerExact(args[4]);
                        if (target == null) {
                            Gastronomicon.sendMessage(player, "&cUnknown player!");
                            return true;
                        }
                        String foodId = args[2];
                        if (!GastroFood.getGastroFoodIds().stream().filter(str -> !str.startsWith("GN_PERFECT")).anyMatch(str -> str.equals(foodId))) {
                            Gastronomicon.sendMessage(player, "&cUnknown food!");
                            return true;
                        }
                        return this.commandProficiencyModify(player, target, args[1], foodId, amount);
                    }
                }
                return false;
            }
        }
        return false;
    }

    private void sendProficiencies(Player player, Player toCheck) {
        Gastronomicon.sendMessage(player, Gastronomicon.getInstance().getPlayerData().get(player.getUniqueId() + ".proficiencies", "Something went wrong!").toString());
    }

    private void sendInfo(Player player) {
        player.sendMessage(new String[]{"", GastroTheme.PERFECT_FOOD.getColor() + "\u00a7lGastronomicon \u00a78- \u00a77Version " + Gastronomicon.getInstance().getPluginVersion(), "\u00a7f------", GastroTheme.PERFECT_FOOD.getColor() + "\u00a7lWiki \u00a7f- \u00a77https://schn.pages.dev/gastronomicon", GastroTheme.PERFECT_FOOD.getColor() + "\u00a7lIssues \u00a7f- \u00a77https://github.com/SchnTgaiSpock/Gastronomicon/issues", ""});
    }

    private void sendHelp(Player player) {
        Gastronomicon.sendMessage(player, "The help section is a WIP! For now, please see https://schn.pages.dev/gastronomicon");
    }

    private void sendCredits(Player player) {
        player.sendMessage(new String[]{GastroTheme.PERFECT_FOOD.getColor() + "\u00a7lGastronomicon \u00a78- \u00a77Credits:", "\u00a7f------", "\u00a77Some head textures were taken and/or modified from https://minecraft-heads.com/ and https://headdb.org/"});
    }

    private boolean commandProfile(Player player) {
        if (!Gastronomicon.checkPermission(player, "gastronomicon.checkprofile", GastroTheme.PERFECT_FOOD.getColor() + "\u00a7lGastronomicon&7> &cYou do not have permission to check your profile!")) {
            return true;
        }
        Gastronomicon.sendMessage(player, "Proficiencies:");
        this.sendProficiencies(player, player);
        return true;
    }

    private boolean commandProfile(Player player, Player other) {
        if (!Gastronomicon.checkPermission(player, "gastronomicon.checkotherprofile", GastroTheme.PERFECT_FOOD.getColor() + "\u00a7lGastronomicon&7> &cYou do not have permission to check another player's profile!")) {
            return true;
        }
        Gastronomicon.sendMessage(player, other.getName() + "'s Proficiencies:");
        this.sendProficiencies(player, other);
        return true;
    }

    private boolean commandProficiencyGet(Player player, String foodId) {
        if (!Gastronomicon.checkPermission(player, "gastronomicon.checkprofile", GastroTheme.PERFECT_FOOD.getColor() + "\u00a7lGastronomicon&7> &cYou do not have permission to check your profile!")) {
            return true;
        }
        if (!GastroFood.getGastroFoodIds().stream().filter(str -> !str.startsWith("GN_PERFECT")).anyMatch(str -> str.equals(foodId))) {
            Gastronomicon.sendMessage(player, "&cUnknown food!");
            return true;
        }
        AddonConfig playerData = Gastronomicon.getInstance().getPlayerData();
        int prof = playerData.getInt(player.getUniqueId().toString() + ".proficiencies." + foodId, 0);
        Gastronomicon.sendMessage(player, foodId + ": " + prof);
        return true;
    }

    private boolean commandProficiencyGet(Player player, Player other, String foodId) {
        if (!Gastronomicon.checkPermission(player, "gastronomicon.checkotherprofile", GastroTheme.PERFECT_FOOD.getColor() + "\u00a7lGastronomicon&7> &cYou do not have permission to check another player's profile!")) {
            return true;
        }
        if (!GastroFood.getGastroFoodIds().stream().filter(str -> !str.startsWith("GN_PERFECT")).anyMatch(str -> str.equals(foodId))) {
            Gastronomicon.sendMessage(player, "&cUnknown food!");
            return true;
        }
        AddonConfig playerData = Gastronomicon.getInstance().getPlayerData();
        int prof = playerData.getInt(other.getUniqueId().toString() + ".proficiencies." + foodId, 0);
        Gastronomicon.sendMessage(player, foodId + ": " + prof);
        return true;
    }

    private boolean commandProficiencyModify(Player player, Player other, String mode, String foodId, int amount) {
        AddonConfig playerData = Gastronomicon.getInstance().getPlayerData();
        String proficiencyPath = player.getUniqueId() + ".proficiencies." + foodId;
        switch (mode) {
            case "set": {
                playerData.set(proficiencyPath, amount);
                Gastronomicon.sendMessage(player, "Successefully set " + foodId + " proficiency to " + amount + "for " + other.getName());
                break;
            }
            case "add": {
                playerData.set(proficiencyPath, playerData.getInt(proficiencyPath, 0) + amount);
                Gastronomicon.sendMessage(player, "Successefully added " + amount + " " + foodId + " proficiency for " + other.getName());
                break;
            }
            case "sub": {
                playerData.set(proficiencyPath, Math.min(playerData.getInt(proficiencyPath, 0) - amount, 0));
                Gastronomicon.sendMessage(player, "Successefully removed " + amount + " " + foodId + " proficiency for " + other.getName());
                break;
            }
            default: {
                Gastronomicon.sendMessage(player, "Unknown mode!");
                return false;
            }
        }
        playerData.save();
        return true;
    }
}

